<?php

namespace App\Enums;

use Spatie\Enum\Enum;

/**
 * @method static self gratuito()
 * @method static self comercial()
 * @method static self educacional()
 * @method static self medico()
 */
class TipoConvenioEnum extends Enum
{
    const MAP_INDEX = [
        'gratuito' => 1,
        'comercial' => 2,
        'educacional' => 3,
        'medico' => 4,
    ];
    const MAP_VALUE = [
        'gratuito' => 'GRATUITO',
        'comercial' => 'COMERCIAL',
        'educacional' => 'EDUCACIONAL',
        'medico' => 'MÉDICO',
    ];
}
