<?php

namespace App\Enums;

use Spatie\Enum\Enum;

/**
 * @method static self atendido()
 * @method static self faltou()
 * @method static self desmarcou()
 * @method static self aberto()
 * @method static self esperandoRecepcao()
 */
class StatusAgendamentoAtendimentoEnum extends Enum
{
    const MAP_INDEX = [
        'atendido' => 1,
        'faltou' => 2,
        'desmarcou' => 3,
        'aberto' => 4,
        'esperandoRecepcao' => 5
    ];
    const MAP_VALUE = [
        'atendido' => 'ATENDIDO',
        'faltou' => 'FALTOU',
        'desmarcou' => 'DESMARCOU',
        'aberto' => 'EM ABERTO',
        'esperandoRecepcao' => 'ESPERANDO NA RECEPÇÃO',
    ];
}
