<?php

namespace App\Enums;

use Spatie\Enum\Enum;

/**
 * @method static self solteiro()
 * @method static self casado()
 * @method static self divorciado()
 * @method static self viuvo()
 * @method static self uniaoEstavel()
 */
class EstadoCivilEnum extends Enum
{
    const MAP_INDEX = [
        'solteiro' => 1,
        'casado' => 2,
        'divorciado' => 3,
        'viuvo' => 4,
        'uniaoEstavel' => 5,
    ];
    const MAP_VALUE = [
        'solteiro' => 'SOLTEIRO (A)',
        'casado' => 'CASADO (A)',
        'divorciado' => 'DIVORCIADO (A)',
        'viuvo' => 'VIÚVO (A)',
        'uniaoEstavel' => 'UNIÃO ESTÁVEL',
    ];
}
