<?php

namespace App\Enums;

use Spatie\Enum\Enum;

/**
 * @method static self nome()
 * @method static self cpf()
 * @method static self rg()
 * @method static self data_nascimento()
 * @method static self sexo()
 * @method static self nome_mae()
 * @method static self nome_pai()
 * @method static self estado_civil()
 * @method static self telefone()
 * @method static self email()
 * @method static self endereco()
 * @method static self secretaria()
 * @method static self secao()
 * @method static self endereco_secao()
 * @method static self telefone_secao()
 */
class ColunasExportacaoCSVEnum extends Enum
{
    const MAP_INDEX = [
        'nome' => 1,
        'cpf' => 2,
        'rg' => 3,
        'data_nascimento' => 4,
        'sexo' => 5,
        'nome_mae' => 6,
        'nome_pai' => 7,
        'estado_civil' => 8,
        'telefone' => 9,
        'email' => 10,
        'endereco' => 11,
        'secretaria' => 12,
        'secao' => 13,
        'endereco_secao' => 14,
        'telefone_secao' => 15,
    ];
    const MAP_VALUE = [
        'nome' => 'NOME',
        'cpf' => 'CPF',
        'rg' => 'RG',
        'data_nascimento' => 'DATA NASCIMENTO',
        'sexo' => 'SEXO',
        'nome_mae' => 'NOME DA MÃE',
        'nome_pai' => 'NOME DO PAI',
        'estado_civil' => 'ESTADO CIVIL',
        'telefone' => 'TELEFONE',
        'email' => 'E-MAIL',
        'endereco' => 'ENDEREÇO',
        'secretaria' => 'SECRETARIA',
        'secao' => 'SEÇÃO',
        'endereco_secao' => 'ENDEREÇO DA SEÇÃO',
        'telefone_secao' => 'TELEFONE DA SEÇÃO',
    ];
}
