<?php

namespace App\Console;

use App\Console\Commands\EnviaSMSAgendamentosCommand;
use App\Console\Commands\IncluiContasRecorrentesMensaisCommand;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        EnviaSMSAgendamentosCommand::class,
        IncluiContasRecorrentesMensaisCommand::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('agendamentos:envia-sms')
                 ->daily();
        $schedule->command('contas:inclui-recorrentes-mensais')
                 ->monthly();
        $schedule->command('contas:inclui-recorrentes-anuais')
                 ->monthly();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
