<?php

namespace App\Console\Commands;

use App\Models\AgendamentoAtendimento;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class EnviaSMSAgendamentosCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'agendamentos:envia-sms';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Envia mensagens SMS de confirmação de agendamento 1 dia antes da data';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Log::info(self::class . '...');
        Log::info('Obtendo agendamentos do dia seguinte');
        $agendamentosDiaSeguinte = AgendamentoAtendimento::whereDate('inicio', Carbon::tomorrow())
                                    ->get();
        Log::info("Encontrados {$agendamentosDiaSeguinte->count()} agendamentos");
        Log::info("Enfileirando mensagens para envio...");
        
        $agendamentosDiaSeguinte->each(function ($agendamento) {
            $agendamento->enviaSMSConfirmacao();
        });

        Log::info("Mensagens enfileiradas para envio");
    }
}
