<?php

namespace Tests\Unit;

use App\Services\IncluiUnidadeOrganizacionalService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase as TestCase;

class UnidadeOrganizacionalTest extends TestCase
{
    use RefreshDatabase;

    public function incluiUnidade($nome, $sigla, $superior = null)
    {
        $service = new IncluiUnidadeOrganizacionalService(
            $nome,
            $sigla,
            '000000',
            [['numero' => '1399999999', 'observacoes' => '']],
            $superior,
            null,
        );

        return $service->inclui();
    }

    public function test_transferePara_raiz()
    {
        $unidadePai = $this->incluiUnidade("Prefeitura", "PMS");
        $unidadeFilha = $this->incluiUnidade("Secretaria de gestão", "SEGES", $unidadePai);
        $novaUnidadePai = $this->incluiUnidade("Fundação", "FAMS");

        $this->assertEquals(2, $unidadeFilha->nivel);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha->id}", $unidadeFilha->hierarquia);

        $unidadeFilha->transferePara($novaUnidadePai);

        $this->assertEquals("{$novaUnidadePai->id}/{$unidadeFilha->id}", $unidadeFilha->hierarquia);
        $this->assertEquals(2, $unidadeFilha->nivel);
    }

    public function test_transferePara_raiz_com_filhos()
    {
        $unidadePai = $this->incluiUnidade("Prefeitura", "PMS");
        $unidadeFilha = $this->incluiUnidade("Secretaria de gestão", "SEGES", $unidadePai);
        $unidadeFilha1 = $this->incluiUnidade("Departamento de TI", "DETIC", $unidadeFilha);
        $unidadeFilha2 = $this->incluiUnidade("Departamento de Licitações", "DELIS", $unidadeFilha);
        $novaUnidadePai = $this->incluiUnidade("Fundação", "FAMS");

        $this->assertEquals(2, $unidadeFilha->nivel);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha->id}", $unidadeFilha->hierarquia);

        $unidadeFilha->transferePara($novaUnidadePai);
        $unidadeFilha1->refresh();
        $unidadeFilha2->refresh();

        $this->assertEquals(2, $unidadeFilha->nivel);
        $this->assertEquals("{$novaUnidadePai->id}/{$unidadeFilha->id}", $unidadeFilha->hierarquia);
        $this->assertEquals($novaUnidadePai->id, $unidadeFilha->superior->id);

        $this->assertEquals("{$novaUnidadePai->id}/{$unidadeFilha->id}/{$unidadeFilha1->id}", $unidadeFilha1->hierarquia);
        $this->assertEquals(3, $unidadeFilha1->nivel);

        $this->assertEquals($novaUnidadePai->id, $unidadeFilha->superior->id);
        $this->assertEquals("{$novaUnidadePai->id}/{$unidadeFilha->id}/{$unidadeFilha2->id}", $unidadeFilha2->hierarquia);
        $this->assertEquals(3, $unidadeFilha2->nivel);
    }

    public function test_transferePara_unidade_nivel_2()
    {
        $unidadePai = $this->incluiUnidade("Prefeitura", "PMS");
        $unidadeFilha1 = $this->incluiUnidade("Secretaria de gestão", "SEGES", $unidadePai);
        $unidadeFilha2 = $this->incluiUnidade("Secretaria de planejamento", "SEPLAN", $unidadePai);
        $unidadeFilha3 = $this->incluiUnidade("Departamento de TI", "DETIC", $unidadeFilha1);

        $this->assertEquals(3, $unidadeFilha3->nivel);
        $this->assertEquals($unidadeFilha1->id, $unidadeFilha3->superior->id);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha1->id}/{$unidadeFilha3->id}", $unidadeFilha3->hierarquia);

        $unidadeFilha3->transferePara($unidadeFilha2);

        $this->assertEquals($unidadeFilha2->id, $unidadeFilha3->superior->id);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha2->id}/{$unidadeFilha3->id}", $unidadeFilha3->hierarquia);
        $this->assertEquals(3, $unidadeFilha3->nivel);
    }

    public function test_transferePara_unidade_nivel_2_unidade_destino_com_filhos()
    {
        $unidadePai = $this->incluiUnidade("Prefeitura", "PMS");
        $unidadeFilha1 = $this->incluiUnidade("Secretaria de gestão", "SEGES", $unidadePai);
        $unidadeFilha2 = $this->incluiUnidade("Secretaria de planejamento", "SEPLAN", $unidadePai);
        $unidadeFilha3 = $this->incluiUnidade("Departamento de TI", "DETIC", $unidadeFilha1);

        $unidadeFilha4 = $this->incluiUnidade("Coordenadoria 1", "COUM", $unidadeFilha3);
        $unidadeFilha5 = $this->incluiUnidade("Seção 1", "SEUM", $unidadeFilha4);
        $unidadeFilha6 = $this->incluiUnidade("Seção 2", "SEDOIS", $unidadeFilha4);

        $unidadeFilha7 = $this->incluiUnidade("Coordenadoria 2", "COUM", $unidadeFilha3);
        $unidadeFilha8 = $this->incluiUnidade("Seção 3", "SETRES", $unidadeFilha7);
        $unidadeFilha9 = $this->incluiUnidade("Seção 4", "SEQUATRO", $unidadeFilha7);

        $unidadeFilha3->transferePara($unidadeFilha2);

        $unidadeFilha4->refresh();
        $unidadeFilha5->refresh();
        $unidadeFilha6->refresh();
        $unidadeFilha7->refresh();
        $unidadeFilha8->refresh();
        $unidadeFilha9->refresh();

        $this->assertEquals($unidadeFilha2->id, $unidadeFilha3->superior->id);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha2->id}/{$unidadeFilha3->id}", $unidadeFilha3->hierarquia);
        $this->assertEquals(3, $unidadeFilha3->nivel);

        // Coordenadoria 1
        $this->assertEquals($unidadeFilha3->id, $unidadeFilha4->superior->id);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha2->id}/{$unidadeFilha3->id}/{$unidadeFilha4->id}", $unidadeFilha4->hierarquia);

        // Seções 1 e 2
        $this->assertEquals($unidadeFilha4->id, $unidadeFilha5->superior->id);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha2->id}/{$unidadeFilha3->id}/{$unidadeFilha4->id}/{$unidadeFilha5->id}", $unidadeFilha5->hierarquia);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha2->id}/{$unidadeFilha3->id}/{$unidadeFilha4->id}/{$unidadeFilha6->id}", $unidadeFilha6->hierarquia);

        // Coordenadoria 2
        $this->assertEquals($unidadeFilha3->id, $unidadeFilha7->superior->id);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha2->id}/{$unidadeFilha3->id}/{$unidadeFilha7->id}", $unidadeFilha7->hierarquia);

        // Seções 8 e 9
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha2->id}/{$unidadeFilha3->id}/{$unidadeFilha7->id}/{$unidadeFilha8->id}", $unidadeFilha8->hierarquia);
        $this->assertEquals("{$unidadePai->id}/{$unidadeFilha2->id}/{$unidadeFilha3->id}/{$unidadeFilha7->id}/{$unidadeFilha9->id}", $unidadeFilha9->hierarquia);
    }
}
