<?php

namespace Tests\Unit;

use App\Models\Servidor;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase as TestCase;

class ServidorTest extends TestCase
{
    use RefreshDatabase;

    /**
     * A basic unit test example.
     *
     * @return void
     */
    public function testScopeNaoPerturbe()
    {
        factory(Servidor::class, 3)->create();
        factory(Servidor::class, 2)->create([
            'nao_perturbe' => true,
        ]);

        $this->assertCount(5, Servidor::all());
        $this->assertCount(2, Servidor::naoPerturbe(true)->get());
        $this->assertCount(3, Servidor::naoPerturbe(false)->get());
    }
}
