<?php

namespace Tests\Unit;

use App\Enums\TipoDesligamentoSindicatoEnum;
use App\Models\Matricula;
use App\Models\MotivoFiliacao;
use App\Models\Servidor;
use App\Services\AfiliaSindicatoService;
use App\Services\DesfiliaSindicatoService;
use App\Services\ReafiliaSindicatoService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase as TestCase;

class ReafiliaSindicatoServiceTest extends TestCase
{
    use RefreshDatabase;

    public function test_reafilia()
    {
        $servidor = factory(Servidor::class)->create();
        $service = new AfiliaSindicatoService($servidor, MotivoFiliacao::find(1), today(), null);
        $matricula = $service->afilia();
        $this->assertInstanceOf(Matricula::class, $matricula);

        $serviceDesfilia = new DesfiliaSindicatoService($servidor, 'Motivo', TipoDesligamentoSindicatoEnum::temporario(), today());
        $serviceDesfilia->desfilia();

        $service = new ReafiliaSindicatoService($servidor);
        $matriculaReafiliada = $service->reafilia();

        $this->assertEquals($matricula->id, $matriculaReafiliada->id);
        $this->assertFalse($matriculaReafiliada->wasRecentlyCreated);
    }
}
