<?php

namespace Tests\Unit;

use App\Services\IncluiUnidadeOrganizacionalService;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase as TestCase;

class IncluiUnidadeOrganizacionalServiceTest extends TestCase
{
    use RefreshDatabase;

    public function test_inclui_raiz()
    {
        $service = new IncluiUnidadeOrganizacionalService(
            'Unidade 1',
            'UNI',
            '1000234',
            [['numero' => '1399999999', 'observacoes' => '']],
            null,
            null,
        );
        $unidade = $service->inclui();
        $this->assertEquals('Unidade 1', $unidade->nome);
        $this->assertEquals('UNI', $unidade->sigla);
        $this->assertEquals('1000234', $unidade->centro_custo);
        $this->assertEquals('1399999999', $unidade->contatos()->telefones()->first()->valor);
        $this->assertNull($unidade->enderecos()->first());
        $this->assertNull($unidade->superior);
    }

    public function test_inclui_filha()
    {
        $service = new IncluiUnidadeOrganizacionalService(
            'Unidade pai',
            'UNI',
            '1000234',
            [['numero' => '1399999999', 'observacoes' => '']],
            null,
            null,
        );
        $unidadePai = $service->inclui();

        $serviceFilha = new IncluiUnidadeOrganizacionalService(
            'Unidade filha',
            'UNI',
            '1000234',
            [['numero' => '1399999999', 'observacoes' => '']],
            $unidadePai,
            null,
        );

        $unidadeFilha = $serviceFilha->inclui();
        $this->assertEquals('Unidade filha', $unidadeFilha->nome);
        $this->assertEquals('UNI', $unidadeFilha->sigla);
        $this->assertEquals('1000234', $unidadeFilha->centro_custo);
        $this->assertEquals('1399999999', $unidadeFilha->contatos()->telefones()->first()->valor);
        $this->assertNull($unidadeFilha->enderecos()->first());
        $this->assertEquals('Unidade pai', $unidadeFilha->superior->nome);
    }
}
