<?php

namespace Tests\Unit;

use App\Enums\DiaSemanaEnum;
use App\Enums\StatusAgendamentoAtendimentoEnum;
use App\Models\AgendamentoAtendimento;
use App\Models\HorarioTrabalho;
use App\Models\ServicoAtendimento;
use App\Models\Servidor;
use App\Services\AgendaAtendimentoJuridicoService;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase as TestCase;

class AgendamentoAtendimentoTest extends TestCase
{
    use RefreshDatabase;

    public function test_naoDesmarcouOuFaltou_atendido()
    {
        $inicio = Carbon::createFromFormat('d/m/Y H:i', '25/05/2020 10:00');
        $fim = Carbon::createFromFormat('d/m/Y H:i', '25/05/2020 11:00');
        $pessoa = factory(Servidor::class)->create();
        $servicoAtendimento = factory(ServicoAtendimento::class)->create(['descricao' => 'Serviço jurídico']);
        $servicoAtendimento->horariosTrabalho()->save(
            new HorarioTrabalho(['dia_semana' => DiaSemanaEnum::SEGUNDA()->getName(), 'inicio' => '08:00', 'fim' => '18:00']),
        );
        $service = new AgendaAtendimentoJuridicoService($inicio, $fim, $pessoa, $servicoAtendimento);

        $agendamento = $service->agenda();
        $this->assertInstanceOf(AgendamentoAtendimento::class, $agendamento);
        $agendamento->status = StatusAgendamentoAtendimentoEnum::atendido();
        $agendamento->save();

        $this->assertTrue($agendamento->naoDesmarcouOuFaltou());
    }

    public function test_naoDesmarcouOuFaltou_status_null()
    {
        $inicio = Carbon::createFromFormat('d/m/Y H:i', '25/05/2020 10:00');
        $fim = Carbon::createFromFormat('d/m/Y H:i', '25/05/2020 11:00');
        $pessoa = factory(Servidor::class)->create();
        $servicoAtendimento = factory(ServicoAtendimento::class)->create(['descricao' => 'Serviço jurídico']);
        $servicoAtendimento->horariosTrabalho()->save(
            new HorarioTrabalho(['dia_semana' => DiaSemanaEnum::SEGUNDA()->getName(), 'inicio' => '08:00', 'fim' => '18:00']),
        );
        $service = new AgendaAtendimentoJuridicoService($inicio, $fim, $pessoa, $servicoAtendimento);
        $agendamento = $service->agenda();
        $this->assertInstanceOf(AgendamentoAtendimento::class, $agendamento);
        $this->assertTrue($agendamento->naoDesmarcouOuFaltou());
    }

    public function test_naoDesmarcouOuFaltou_desmarcou()
    {
        $inicio = Carbon::createFromFormat('d/m/Y H:i', '25/05/2020 10:00');
        $fim = Carbon::createFromFormat('d/m/Y H:i', '25/05/2020 11:00');
        $pessoa = factory(Servidor::class)->create();
        $servicoAtendimento = factory(ServicoAtendimento::class)->create(['descricao' => 'Serviço jurídico']);
        $servicoAtendimento->horariosTrabalho()->save(
            new HorarioTrabalho(['dia_semana' => DiaSemanaEnum::SEGUNDA()->getName(), 'inicio' => '08:00', 'fim' => '18:00']),
        );
        $service = new AgendaAtendimentoJuridicoService($inicio, $fim, $pessoa, $servicoAtendimento);
        $agendamento = $service->agenda();
        $this->assertInstanceOf(AgendamentoAtendimento::class, $agendamento);
        $agendamento->status = StatusAgendamentoAtendimentoEnum::desmarcou();
        $agendamento->save();

        $this->assertFalse($agendamento->naoDesmarcouOuFaltou());
    }
}
