<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('vendors/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/moment/min/moment-with-locales.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/daterangepicker/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/contas-pagar-receber/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Contas a pagar e receber</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Contas a pagar e receber
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <div class="form-row">
                    <div class="col-6">
                        <?php $__env->startComponent('components.button', [
                        'route' => 'admin.contas-pagar.create',
                        'icon' => 'plus',
                        'label' => 'Incluir Saída',
                        'class' => 'btn-primary'
                        ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                        <?php $__env->startComponent('components.button', [
                        'route' => 'admin.contas-receber.create',
                        'icon' => 'plus',
                        'label' => 'Incluir Entrada',
                        'class' => 'btn-primary mx-2'
                        ]); ?>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                    <div class="col">
                        <div class="form-inline float-right mx-2">
                            <label for="busca" class="mr-1">Busca</label>
                            <input form="filtro" type="text" name="busca" value="<?php echo e(request()->busca); ?>" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-10 offset-md-2">
                        <div class="form-inline float-right mx-2">
                            <button class="btn btn-outline-primary" type="submit" form="filtro">Filtrar</button>
                            <button id="btn-limpar" class="btn btn-outline-secondary mx-1" type="button" form="filtro">Limpar</button>
                        </div>
                        <div class="btn-group btn-group-toggle float-right" data-toggle="buttons">
                            <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $enabled = $status->isEqual($filtroStatus);
                                    $checked = $enabled ? 'checked' : '';
                                    $active = $enabled ? 'active' : '';
                                ?>
                                <label class="btn btn-outline-secondary <?php echo e($active); ?>">
                                    <input class="status" form="filtro" name="status" value="<?php echo e($status->getIndex()); ?>" type="radio" <?php echo e($checked); ?>> <?php echo e($status); ?>

                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="form-inline float-right mx-2">
                            <label for="vencimento" class="mr-1">Vencimento</label>
                            <input type="text" form="filtro" autocomplete="off" value="<?php echo e($vencimento); ?>" name="vencimento" class="form-control vencimento <?php $__errorArgs = ['vencimento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('vencimento')); ?>">
                        </div>
                    </div>
                </div>
                <form id="filtro">
                </form>

                <table class="table table-sm mt-3">
                    <thead>
                        <tr>
                            <th>Tipo</th>
                            <th>Descrição</th>
                            <th>Status</th>
                            <th>Tipo despesa</th>
                            <th>Data venc.</th>
                            <th>Valor (R$)</th>
                            <th>Doc. Pendente</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $contas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(optional($conta->tipo)->getValue()); ?></td>
                            <td>
                                <div class="row"><?php echo e($conta->descricao); ?></div>
                                <div class="row"><span style="font-size: 0.7em"><?php echo e($conta->observacoes); ?></span></div>
                            </td>
                            <td><?php echo e($conta->status->getValue()); ?></td>
                            <td><?php echo e(optional($conta->tipo_despesa)->getValue()); ?></td>
                            <td><?php echo e($conta->vencimento->format('d/m/Y')); ?></td>
                            <td><?php echo e(number_format($conta->valor, 2, ',', '.')); ?></td>
                            <td><?php if($conta->caminho_documento): ?> Não <?php else: ?> Sim <?php endif; ?></td>
                            <td>
                                <?php if($conta->tipo->isEntrada()): ?>
                                    <?php $__env->startComponent('components.button', [
                                    'route' => 'admin.contas-receber.edit',
                                    'routeParams' => ['conta' => $conta],
                                    'class' => 'btn-primary',
                                    'label' => 'Visualizar/Editar',
                                    'icon' => 'edit'
                                    ]); ?>
                                    <?php echo $__env->renderComponent(); ?>
                                <?php else: ?>
                                    <?php $__env->startComponent('components.button', [
                                    'route' => 'admin.contas-pagar.edit',
                                    'routeParams' => ['conta' => $conta],
                                    'class' => 'btn-primary',
                                    'label' => 'Visualizar/Editar',
                                    'icon' => 'edit'
                                    ]); ?>
                                    <?php echo $__env->renderComponent(); ?>
                                <?php endif; ?>
                                <?php $__env->startComponent('components.button', [
                                'class' => 'btn-danger btn-excluir-conta',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.contas-pagar-receber.destroy',
                                'routeParams' => ['conta' => $conta],
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($contas->links()); ?>

            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-conta" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-conta">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir a conta?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sindserv/resources/views/admin/contas-pagar-receber/index.blade.php ENDPATH**/ ?>