
<?php
$form = $form ?? 'form-servidor';
?>

<div class="modal fade" id="modal-logradouro-lotacao" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4>Lotação Servidor</h4>
            </div>
            <div class="modal-body">
                <div id="div-alert-lotacao" class="alert alert-danger alert-dismissible" role="alert">
                    <p></p>
                </div>
                <div class="form-row">
                    <input type="hidden" id="hidden-url-logradouro-api-cep" value="<?php echo e(route('api.logradouro-api.busca-cep')); ?>">
                    <div class="col-3">
                        <label for="cep_lotacao">CEP *</label>
                        <div class="input-group">
                            <input type="text" id="text-cep-lotacao" form="<?php echo e($form); ?>" data-mask="00000-000" data-mask-clearifnotmatch="true" name="cep_lotacao" value="<?php echo e(old('cep_lotacao')); ?>" maxlength="8" class="form-control">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" id="btn-busca-cep-lotacao"><i data-feather="search"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-4">
                        <label for="logradouro_lotacao">Logradouro *</label>
                        <input type="text" id="text-logradouro-lotacao" form="<?php echo e($form); ?>" name="logradouro_lotacao" maxlength="150" class="form-control" value="<?php echo e(old('logradouro_lotacao')); ?>">
                    </div>
                    <div class="form-group col-2">
                        <label for="numero_lotacao">Número *</label>
                        <input type="text" id="text-numero-lotacao" form="<?php echo e($form); ?>" name="numero_lotacao" maxlength="150" class="form-control" value="<?php echo e(old('numero_lotacao')); ?>">
                    </div>
                    <div class="form-group col-3">
                        <label for="bairro_lotacao">Bairro *</label>
                        <input type="text" id="text-bairro-lotacao" form="<?php echo e($form); ?>" name="bairro_lotacao" maxlength="50" class="form-control" value="<?php echo e(old('bairro_lotacao')); ?>">
                    </div>
                    <div class="form-group col-4">
                        <label for="cidade_lotacao">Cidade *</label>
                        <input type="text" id="text-cidade-lotacao" form="<?php echo e($form); ?>" name="cidade_lotacao" maxlength="100" class="form-control" value="<?php echo e(old('cidade_lotacao')); ?>">
                    </div>
                    <div class="form-group col-2">
                        <label for="estado_lotacao">Estado *</label>
                        <select name="estado_lotacao" form="<?php echo e($form); ?>" id="select-estado-lotacao" class="form-control estado">
                            <?php
                            $estadoSelecionado = old('estado_lotacao', 'SP')
                            ?>
                            <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($estado->ufe_sg); ?>" <?php echo e($estadoSelecionado == $estado->ufe_sg ? 'selected' : ''); ?>><?php echo e($estado->ufe_sg); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-6">
                        <label for="observacoes_lotacao">Obs. endereço</label>
                        <input type="text" name="observacoes_lotacao" form="<?php echo e($form); ?>" maxlength="100" class="form-control" value="<?php echo e(old('observacoes_lotacao')); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-seleciona-logradouro-lotacao" class="btn btn-primary">Selecionar</button>
                <button type="button" id="btn-cancelar-selecao-logradouro" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/gabriel/repos/sindserv/resources/views/components/modal-endereco-lotacao.blade.php ENDPATH**/ ?>