<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config('app.name')); ?> - Cancelamento OSAN</title>
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressao.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressos/formulario-cancelamento-osan.css')); ?>">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        <?php $__env->startComponent('components.impressos.cabecalho'); ?><?php echo $__env->renderComponent(); ?>

        <h1>CANCELAMENTO DO <br>CONVÊNIO OSAN/SINDSERV</h1>

        <p>
            Eu <?php echo e($servidor->nome); ?>, registro funcional nº <?php echo e($registro->numero); ?>, regime <?php echo e($registro->regime); ?> lotado(a) na
            Secretaria <?php echo e($secretaria); ?>, venho requerer <b>o cancelamento do desconto</b> do convênio OSAN <b>código <?php echo e($codigoMensalidade); ?></b>
            junto à <?php echo e($empresa); ?>, a partir do mês ________________________.
        </p>

        <div class="data">Santos, <?php echo e(today()->format('d/m/Y')); ?></div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Associado
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Diretor
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Funcionário SINDSERV
            </div>
        </div>

        <?php $__env->startComponent('components.impressos.rodape'); ?><?php echo $__env->renderComponent(); ?>
    </div>
</body>

</html>
<?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/impressos/formulario-cancelamento-osan.blade.php ENDPATH**/ ?>