<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page"><a href="<?php echo e(route('admin.dependentes.busca')); ?>">Dependentes</a></li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Dependentes
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <form id="filtro">
                    <div class="form-row">
                        <div class="input-group col-4 offset-md-8">
                            <input type="text" autocomplete="off" value="<?php echo e($busca ?? ''); ?>" name="busca" class="form-control busca <?php $__errorArgs = ['busca'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <div class="input-group-append">
                                <button type="submit" class="btn btn-outline-secondary" title="Buscar"><i data-feather="search"></i></button>
                                <a href="<?php echo e(route('admin.dependentes.busca')); ?>" class="btn btn-outline-secondary" title="Limpar"><i data-feather="x"></i></a>
                            </div>
                        </div>
                    </div>
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Titular</th>
                            <th>Tipo</th>
                            <th>Grau</th>
                            <th>Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $dependentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dependente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($dependente->nome); ?></td>
                            <td><?php echo e($dependente->dependivel->nome); ?></td>
                            <td><?php echo e(ucfirst($dependente->dependivel->tipoFormatado())); ?></td>
                            <td><?php echo e($dependente->grau_parentesco->getValue()); ?></td>
                            <td>
                                <?php if($dependente->dependivel->tipo() == 'associado'): ?>
                                    <?php $__env->startComponent('components.button', [
                                        'route' => 'admin.servidores.edit',
                                        'routeParams' => ['servidor' => $dependente->dependivel_id],
                                        'class' => 'btn-primary',
                                        'label' => 'Abrir titular',
                                        'icon' => 'edit'
                                        ]); ?>
                                    <?php echo $__env->renderComponent(); ?>
                                    <?php $__env->startComponent('components.button', [
                                        'route' => 'admin.servidores.dependentes.edit',
                                        'routeParams' => ['servidor' => $dependente->dependivel_id, 'dependente' => $dependente->id],
                                        'class' => 'btn-primary',
                                        'label' => 'Abrir dependente',
                                        'icon' => 'edit'
                                        ]); ?>
                                    <?php echo $__env->renderComponent(); ?>
                                <?php else: ?>
                                    <?php $__env->startComponent('components.button', [
                                        'route' => 'admin.funcionarios.edit',
                                        'routeParams' => ['funcionario' => $dependente->dependivel_id],
                                        'class' => 'btn-primary',
                                        'label' => 'Abrir principal',
                                        'icon' => 'edit'
                                        ]); ?>
                                    <?php echo $__env->renderComponent(); ?>
                                    <?php $__env->startComponent('components.button', [
                                        'route' => 'admin.funcionarios.dependentes.edit',
                                        'routeParams' => ['funcionario' => $dependente->dependivel_id, 'dependente' => $dependente->id],
                                        'class' => 'btn-primary',
                                        'label' => 'Abrir dependente',
                                        'icon' => 'edit'
                                        ]); ?>
                                    <?php echo $__env->renderComponent(); ?>
                                <?php endif; ?>
                                
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($dependentes->links()); ?>

            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/dependentes/busca.blade.php ENDPATH**/ ?>