<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('vendors/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('vendors/moment/min/moment-with-locales.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/daterangepicker/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/movimento-caixa/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Movimento de Caixa</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Movimento de Caixa
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <div class="row">
                    <div class="col-10 offset-md-2">
                        <div class="form-inline float-right mx-2">
                            <button class="btn btn-outline-primary" type="submit" form="filtro">Filtrar</button>
                            <button id="btn-limpar" class="btn btn-outline-secondary mx-1" type="button" form="filtro">Limpar</button>
                        </div>
                        <div class="form-inline float-right mx-2">
                            <label for="periodo" class="mr-1">Período</label>
                            <input type="text" form="filtro" autocomplete="off" value="<?php echo e($periodo); ?>" name="periodo" class="form-control periodo <?php $__errorArgs = ['periodo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('periodo')); ?>">
                        </div>
                        <div class="form-inline float-right mx-2">
                            <label for="nota_fiscal" class="mr-1">Nota fiscal</label>
                            <input type="text" form="filtro" value="<?php echo e($notaFiscal); ?>" name="nota_fiscal" class="form-control <?php $__errorArgs = ['nota_fiscal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nota_fiscal')); ?>">
                        </div>
                    </div>
                </div>

                <form id="filtro">
                </form>

                <table class="table table-sm mt-3 table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Descrição</th>
                            <th>Valor venc.(R$)</th>
                            <th>Valor pago (R$)</th>
                            <th>Data</th>
                            <th>Tipo</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $movimentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $movimento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($movimento->id); ?></td>
                            <td><?php echo e($movimento->descricao); ?></td>
                            <td><?php echo e(number_format($movimento->valor, 2, ',', '.')); ?></td>
                            <td><?php echo e(number_format($movimento->valor_pago, 2, ',', '.')); ?></td>
                            <td><?php echo e($movimento->data_pagamento->format('d/m/Y')); ?></td>
                            <td><?php echo e($movimento->tipo->getValue()); ?></td>
                            <td>
                                <?php if($movimento->tipo->isEntrada()): ?>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.contas-receber.edit',
                                'routeParams' => ['conta' => $movimento],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php else: ?>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.contas-pagar.edit',
                                'routeParams' => ['conta' => $movimento],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($movimentos->links()); ?>


                <hr>
                <table class="table table-sm col-4 float-right">
                    <tr>
                        <th>Entrada</th>
                        <td class="table-success">R$ <?php echo e(number_format($saldo->entrada, 2, ',', '.')); ?></td>
                    </tr>
                    <tr>
                        <th>Saída</th>
                        <td class="table-danger">R$ <?php echo e(number_format($saldo->saida, 2, ',', '.')); ?></td>
                    </tr>
                    <tr>
                        <th>Saldo</th>
                        <td class="<?php echo e($saldo->saldo > 0 ? 'table-info' : 'table-danger'); ?>">
                            R$ <?php echo e(number_format($saldo->saldo, 2, ',', '.')); ?>

                        </td>
                    </tr>
                </table>
                <div class="clearfix"></div>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-movimento" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-movimento">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o movimento?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/movimento-caixa/index.blade.php ENDPATH**/ ?>