<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/exportacao-csv/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Exportação de CSV</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Exportação de CSV
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <div class="alert alert-info" role="alert">
                    <b>Atenção: </b>Selecione codificação UTF-8 e separador por vírgula no seu software de planilhas.
                </div>
                <form method="POST" action="<?php echo e(route('admin.exportacao-csv.exporta')); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="form-row">
                        <h5>Filtro</h5>
                        <hr class="col-12">

                        <div class="form-group col-3">
                            <label for="filtroAtivoAposentado">Ativo/Aposentado</label>
                            <select name="filtroAtivoAposentado" class="form-control">
                                <?php $__currentLoopData = $filtrosAtivosAposentados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filtroAtivoAposentado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($filtroAtivoAposentado->getIndex()); ?>"><?php echo e($filtroAtivoAposentado->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="filtroSituacao">Situação sindical</label>
                            <select name="filtroSituacao" class="form-control">
                                <?php $__currentLoopData = $filtrosSituacao; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filtroSituacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($filtroSituacao->getIndex()); ?>"><?php echo e($filtroSituacao->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <h5>Colunas</h5>
                        <hr class="col-12">
                    </div>
                    <div id="div-colunas" class="form-row col-12">
                        <div class="form-group col-3 coluna">
                            <select name="colunas[]" class="form-control">
                                <?php $__currentLoopData = $colunas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coluna): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($coluna->getIndex()); ?>"><?php echo e($coluna->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <hr>

                    <button id="btn-inclui-coluna" class="btn btn-primary" type="button"><i data-feather="plus"></i> Incluir coluna</button>
                    <button class="btn btn-primary" type="submit"><i data-feather="file-text"></i> Exportar</button>
                </form>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/exportacao-csv/index.blade.php ENDPATH**/ ?>