<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/convenios.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Convênios</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Convênios
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <?php $__env->startComponent('components.button', [
                'route' => 'admin.convenios.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <?php $__env->startComponent('components.busca', [
                'route' => 'admin.convenios.index',
                'busca' => $termo ?? null
                ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Telefone</th>
                            <th>Especialidade</th>
                            <th>Tipo</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $convenios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $convenio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($convenio->nome); ?></td>
                            <td><?php echo e(implode(' ', $convenio->contatos()->telefones()->take(2)->get()->pluck('valor')->toArray())); ?></td>
                            <td><?php echo e($convenio->especialidade->nome); ?></td>
                            <td><?php echo e($convenio->tipo); ?></td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.convenios.edit',
                                'routeParams' => ['convenio' => $convenio],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php $__env->startComponent('components.button', [
                                'class' => 'btn-danger btn-excluir',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.convenios.destroy',
                                'routeParams' => ['convenio' => $convenio],
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($convenios->links()); ?>

            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o convênio?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/convenios/index.blade.php ENDPATH**/ ?>