<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO'])); ?>">Atendimento Jurídico</a></li>
        <?php if(request()->tipo == 'associado'): ?>
            <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => request()->pessoa])); ?>"><?php echo e($pessoa->nome); ?></a></li>
        <?php else: ?>
            <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.funcionarios.edit', ['funcionario' => request()->pessoa])); ?>"><?php echo e($pessoa->nome); ?></a></li>
        <?php endif; ?>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO'])); ?>">Atendimento Jurídico</a></li>
        <li class="breadcrumb-item active" aria-current="page">Processos</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Processos
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <?php $__env->startComponent('components.button', [
                    'route' => 'admin.processos-juridicos.create',
                    'routeParams' => ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'agendamento' => request()->agendamento],
                    'icon' => 'plus',
                    'label' => 'Incluir',
                    'class' => 'btn-primary'
                    ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <?php if(request()->tipo == 'associado'): ?>
                    <?php $__env->startComponent('components.button', [
                        'route' => 'admin.servidores.edit',
                        'routeParams' => ['servidor' => request()->pessoa],
                        'icon' => 'arrow-left',
                        'label' => 'Associado',
                        'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                <?php else: ?>
                    <?php $__env->startComponent('components.button', [
                        'route' => 'admin.funcionarios.edit',
                        'routeParams' => ['funcionario' => request()->pessoa],
                        'icon' => 'arrow-left',
                        'label' => 'Funcionário',
                        'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                <?php endif; ?>

                <?php if(request()->agendamento): ?>
                    <?php $__env->startComponent('components.button', [
                        'route' => 'admin.agendamentos-atendimentos.show',
                        'routeParams' => ['agendamento' => request()->agendamento],
                        'icon' => 'arrow-left',
                        'label' => 'Agendamento',
                        'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                <?php endif; ?>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Número</th>
                            <th>Vara</th>
                            <th>Competência</th>
                            <th>Tipo</th>
                            <th>Resultado</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $processos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $processo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($processo->numero); ?></td>
                            <td><?php echo e($processo->vara); ?></td>
                            <td><?php echo e($processo->competencia->descricao); ?></td>
                            <td><?php echo e($processo->tipoAcao->descricao); ?></td>
                            <td><?php echo e(optional($processo->resultado)->getValue()); ?></td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.processos-juridicos.edit',
                                'routeParams' => ['id' => $processo->id, 'pessoa' => request()->pessoa, 'tipo' => request()->tipo, 'agendamento' => request()->agendamento],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php $__env->startComponent('components.button', [
                                'class' => 'btn-danger btn-excluir',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.processos-juridicos.destroy',
                                'routeParams' => ['id' => $processo->id, 'pessoa' => request()->pessoa, 'tipo' => request()->tipo],
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($processos->links()); ?>

            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o processo?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/processos-juridicos/index.blade.php ENDPATH**/ ?>