<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('vendors/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('vendors/moment/min/moment-with-locales.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/daterangepicker/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/auditoria/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Logs de Auditoria</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Logs de Auditoria
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <form>
                    <div class="row">
                        <div class="col">
                            <div class="form-inline float-right mx-2">
                                <button class="btn btn-outline-primary" type="submit">Filtrar</button>
                                <button id="btn-limpar" class="btn btn-outline-secondary mx-1" type="button">Limpar</button>
                            </div>
                            <div class="form-inline float-right mx-2">
                                <label for="evento" class="mr-1">Evento</label>
                                <select name="evento" class="form-control">
                                    <option value="">Todos</option>
                                    <option value="created" <?php echo e($evento == 'created' ? 'selected' : ''); ?>>Inclusão</option>
                                    <option value="updated" <?php echo e($evento == 'updated' ? 'selected' : ''); ?>>Edição</option>
                                    <option value="deleted" <?php echo e($evento == 'deleted' ? 'selected' : ''); ?>>Exclusão</option>
                                </select>
                            </div>
                            <div class="form-inline float-right mx-2">
                                <label for="intervalo" class="mr-1">Intervalo</label>
                                <input type="text" autocomplete="off" value="<?php echo e($intervalo); ?>" name="intervalo" class="form-control intervalo <?php $__errorArgs = ['intervalo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('vencimento')); ?>">
                            </div>
                        </div>
                    </div>
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Data/hora</th>
                            <th>Tipo</th>
                            <th>Objeto</th>
                            <th>Evento</th>
                            <th>Usuário</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php echo e($log->created_at->format('d/m/Y H:i:s')); ?>

                            </td>
                            <td>
                                <?php echo e($log->auditable_type_readable); ?>

                            </td>
                            <td>
                                <?php echo e(str_limit($log->description, 50)); ?>

                            </td>
                            <td>
                                <?php echo e(Str::ucfirst($log->event_readable)); ?>

                            </td>
                            <td>
                                <?php echo e($log->user->name); ?>

                            </td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.auditoria.show',
                                'routeParams' => ['log' => $log],
                                'class' => 'btn-primary',
                                'label' => 'Detalhes',
                                'icon' => 'eye'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($logs->links()); ?>

            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/auditoria/index.blade.php ENDPATH**/ ?>