<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('css/admin/servidores-create-edit.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/servidores/desfilia.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.index')); ?>">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => $servidor])); ?>"><?php echo e($servidor->nome); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Desfiliar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Desfiliar servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="<?php echo e(route('admin.servidores.desfilia', ['servidor' => $servidor])); ?>" method="post">
                    <?php echo csrf_field(); ?>

                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="matricula">Matrícula</label>
                            <input type="text" name="matricula" maxlength="100" readonly class="form-control-plaintext" value="<?php echo e($matricula->id); ?>">
                        </div>
                        <?php if($servidor->eAssociado()): ?>
                        <div class="form-group col-2">
                            <label for="tipo_desligamento">Tipo *</label>
                            <select name="tipo_desligamento" id="tipo_desligamento" class="form-control">
                                <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($tipo->getIndex()); ?>" <?php if(old('tipo_desligamento')==$tipo->getIndex()): ?> selected <?php endif; ?>><?php echo e($tipo->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-4" id="div-motivo-temporario">
                            <label for="motivo_desligamento_temporario">Motivo *</label>
                            <select class="form-control" id="motivo_desligamento_temporario" name="motivo_desligamento_temporario">
                                <option value=""></option>
                                <?php $__currentLoopData = $motivosTemporario; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $motivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($motivo->getIndex()); ?>" <?php if(old('motivo_desligamento_temporario')==$motivo->getindex()): ?> selected <?php endif; ?>><?php echo e($motivo->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-4" id="div-motivo-definitivo">
                            <label for="motivo_desligamento_definitivo">Motivo *</label>
                            <select class="form-control" id="motivo_desligamento_definitivo" name="motivo_desligamento_definitivo">
                                <option value=""></option>
                                <?php $__currentLoopData = $motivosDefinitivo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $motivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($motivo->getIndex()); ?>" <?php if(old('motivo_desligamento_definitivo')==$motivo->getindex()): ?> selected <?php endif; ?>><?php echo e($motivo->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php elseif($servidor->desfiliadoTemporariamente()): ?>
                        <div class="form-group col-6" id="div-motivo-definitivo">
                            <label for="motivo_desligamento_definitivo">Motivo *</label>
                            <select class="form-control" id="motivo_desligamento_definitivo" name="motivo_desligamento_definitivo">
                                <option value=""></option>
                                <?php $__currentLoopData = $motivosDefinitivo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $motivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($motivo->getIndex()); ?>" <?php if(old('motivo_desligamento_definitivo')==$motivo->getindex()): ?> selected <?php endif; ?>><?php echo e($motivo->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <?php endif; ?>
                        <div class="form-group col-2">
                            <label for="data_desligamento">Data *</label>
                            <input type="text" required name="data_desligamento" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control  <?php $__errorArgs = ['data_desligamento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_desligamento', today()->format('d/m/Y'))); ?>">
                        </div>
                        <div class="form-group col-2" id="div-data-falecimento">
                            <label for="data_falecimento">Data falecimento</label>
                            <input type="text" name="data_falecimento" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control  <?php $__errorArgs = ['data_falecimento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_falecimento')); ?>">
                        </div>
                        <div class="form-group col-2" id="div-data-publicacao-portaria">
                            <label for="data_publicacao_portaria">Data portaria</label>
                            <input type="text" name="data_publicacao_portaria" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control  <?php $__errorArgs = ['data_publicacao_portaria'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_publicacao_portaria')); ?>">
                        </div>
                        <div class="form-group col-3" id="div-mes-ano-parou-desconto">
                            <label for="mes_ano_parou_desconto">Mês/ano parou desconto</label>
                            <input type="text" name="mes_ano_parou_desconto" data-mask="00/0000" data-mask-clearifnotmatch="true" class="form-control  <?php $__errorArgs = ['mes_ano_parou_desconto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('mes_ano_parou_desconto')); ?>">
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Desfiliar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/servidores/desfilia.blade.php ENDPATH**/ ?>