<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/convenios-pessoas/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.index')); ?>">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => $servidor])); ?>"><?php echo e($servidor->nome); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Convênios</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Convênios
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <input type="hidden" id="hidden-termos-assinar" value="<?php echo e(session('termos-assinar')); ?>">

                <?php $__env->startComponent('components.button', [
                'route' => 'admin.servidores.convenios.create',
                'routeParams' => ['servidor' => $servidor],
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Convênio</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $convenios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $convenio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($convenio->convenio->nome); ?></td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.servidores.convenios.edit',
                                'routeParams' => ['servidor' => $servidor, 'convenio' => $convenio],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php $__env->startComponent('components.button', [
                                'class' => 'btn-danger btn-excluir',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.servidores.convenios.destroy',
                                'routeParams' => ['servidor' => $servidor, 'convenio' => $convenio],
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o convênio do servidor?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-termos-assinar" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <p><?php echo e(session('status')); ?></p>
            </div>
            <div class="modal-body">
                <p>Atenção: Este convênio possui um termo a ser assinado no seu desligamento.</p>
            </div>
            <div class="modal-footer">
                <a href="<?php echo e(session('rota-termo')); ?>" target="new" type="button" class="btn btn-primary">Abrir termo</a>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/servidores/convenios/index.blade.php ENDPATH**/ ?>