<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config('app.name')); ?> - Desligamento sindicato</title>
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressao.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/admin/impressos/formulario-desligamento-sindicato.css')); ?>">
</head>

<body onload="javascript:print()">
    <div id="wrapper">
        <?php $__env->startComponent('components.impressos.cabecalho'); ?><?php echo $__env->renderComponent(); ?>

        <p class="cabecalho">
            À<br>
            DIRETORIA COLEGIADA<br>
            DD. Sindicato dos Servidores Públicos Municipais de Santos - SINDSERV
        </p>

        <h1>DESLIGAMENTO DE ASSOCIADO</h1>

        <p>
            Eu <?php echo e($servidor->nome); ?>, RG nº <?php echo e($servidor->rg); ?>, CPF sob o nº <?php echo e($servidor->cpf); ?>

            vem por meio desta, renunciar os poderes outorgados ao Advogados do Sindicato, ficando
            ciente de que à partir desta data não terei mais direito de usufruir do atendimento no
            Departamento Jurídico, com anuência e homologação da entidade sindical.
        </p>
        <p>
            A presente renúncia é a manifestação de minha vontade própria feita perante as testemunhas e em caráter revogável.
        </p>
        <p>
            <b>(Obs: O renunciante terá de outorgar os poderes a um advogado particular, para que responda em sua causa(s).)</b>
        </p>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Associado
            </div>

            <div class="assinatura">
                ______________________________________<br>
                Assinatura do Diretor
            </div>
        </div>

        <div class="assinaturas">
            <div class="assinatura">
                ______________________________________<br>
                Assinatura da Testemunha
            </div>
        </div>

        <p class="data-recebimento">Recebemos pela Secretaria Geral ________/________/__________</p>

        <?php $__env->startComponent('components.impressos.rodape'); ?><?php echo $__env->renderComponent(); ?>
    </div>
</body>

</html>
<?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/impressos/formulario-desligamento-sindicato-renuncia-poderes-advogados.blade.php ENDPATH**/ ?>