<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/dependentes/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route($routes['dependido']['index']['route'])); ?>"><?php echo e($dependido); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route($routes['dependido']['edit']['route'], $routes['dependido']['edit']['params'])); ?>"><?php echo e($routes['dependido']['nome']); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page">Dependentes</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Dependentes
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <?php $__env->startComponent('components.button', [
                'route' => $routes['dependente']['create']['route'],
                'routeParams' => $routes['dependente']['create']['params'],
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Data de nascimento</th>
                            <th>Grau</th>
                            <th>Especial</th>
                            <th>Convênios</th>
                            <th>Ativo</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $dependentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dependente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $listaConvenios = implode(', ', $dependente->convenios->pluck('convenio.nome')->toArray());
                        ?>
                        <tr>
                            <td><?php echo e($dependente->nome); ?></td>
                            <td><?php echo e($dependente->data_nascimento->format('d/m/Y')); ?></td>
                            <td><?php echo e($dependente->grau_parentesco->getValue()); ?></td>
                            <td><?php echo e($dependente->especial ? 'SIM' : 'NÃO'); ?></td>
                            <td><?php echo e($listaConvenios); ?></td>
                            <td><?php echo e($dependente->ativo ? 'SIM' : 'NÃO'); ?></td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => $routes['dependente']['edit']['route'],
                                'routeParams' => [$routes['dependido']['key'] => $routes['dependente']['edit']['params'][$routes['dependido']['key']], 'dependente' => $dependente],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php $__env->startComponent('components.button', [
                                'class' => 'btn-danger btn-excluir-dependente',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => $routes['dependente']['destroy']['route'],
                                'routeParams' => [$routes['dependido']['key'] => $routes['dependente']['destroy']['params'][$routes['dependido']['key']], 'dependente' => $dependente],
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-dependente" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-dependente">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o dependente?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/dependentes/index.blade.php ENDPATH**/ ?>