<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/planos-contas.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Planos de contas</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Planos de conta
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>
                
                <?php $__env->startComponent('components.button', [
                'route' => 'admin.planos-contas.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <?php $__env->startComponent('components.busca', [
                'route' => 'admin.planos-contas.index',
                'busca' => $busca
                ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $planos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($plano->nome); ?></td>
                            <td>
                                <?php $__env->startComponent('components.button', [
                                'route' => 'admin.planos-contas.edit',
                                'routeParams' => ['plano' => $plano],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                                <?php $__env->startComponent('components.button', [
                                'class' => 'btn-danger btn-excluir-plano',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.planos-contas.destroy',
                                'routeParams' => ['plano' => $plano],
                                ]); ?>
                                <?php echo $__env->renderComponent(); ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($planos->links()); ?>

            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-plano" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-plano">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o plano e todas as classificações relacionadas a ele?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/planos-contas/index.blade.php ENDPATH**/ ?>