<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.guia-atendimento.index')); ?>">Guia de atendimento</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir atendimento - <?php echo e($servidor->nome); ?>

        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="<?php echo e(route('admin.guia-atendimento.store', ['servidor' => $servidor])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <div class="form-row">
                        <div class="form-group col-12">
                            <label for="atendimento">Atendimento *</label>
                            <textarea rows="5" type="text" required autofocus name="atendimento" class="form-control <?php $__errorArgs = ['atendimento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('atendimento')); ?></textarea>
                        </div>
                        <div class="form-group col-4">
                            <label for="motivo_id">Motivo *</label>
                            <select name="motivo_id" class="form-control">
                            <?php $__currentLoopData = $motivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $motivo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($motivo->id); ?>"><?php echo e($motivo->descricao); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="resolvido">Resolvido *</label>
                            <select name="resolvido" class="form-control">
                                <option value="0" <?php echo e(! old('resolvido') ? 'selected' : ''); ?>>NÃO</option>
                                <option value="1" <?php echo e(old('resolvido') ? 'selected' : ''); ?>>SIM</option>
                            </select>
                        </div>
                    </div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.guia-atendimento.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5><?php echo e(session('status')); ?></h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar o prestador ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Continuar e editar</button>
                <a href="<?php echo e(route('admin.guia-atendimento.index')); ?>" class="btn btn-secondary">Voltar</a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/guia-atendimento/create.blade.php ENDPATH**/ ?>