<?php $__env->startPush('css'); ?>
<link href="<?php echo e(asset('css/admin/servidores-create-edit.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/servidores/edit.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/telefones.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/emails.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.index')); ?>">Servidores</a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e($servidor->nome); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="<?php echo e(route('admin.servidores.update', ['servidor' => $servidor])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <input type="hidden" id="hidden-sucesso-inclusao" value="<?php echo e(session('sucessoInclusao')); ?>">
                    <input type="hidden" id="hidden-sucesso-filiacao" value="<?php echo e(session('sucessoFiliacao')); ?>">
                    <input type="hidden" id="hidden-rota-voltar" value="<?php echo e(session('rotaVoltar')); ?>">
                    <input type="hidden" id="hidden-e-associado" value="<?php echo e($servidorEAssociado); ?>">
                    <input type="hidden" id="hidden-termos-assinar" value="<?php echo e(session('termos-assinar')); ?>">

                    <div class="form-row">
                        <div class="col-9">
                            <div class="form-row">
                                <div class="form-group col-3">
                                    <label for="situacao">Situação</label>
                                    <input type="text" name="situacao" readonly class="form-control-plaintext" value="<?php echo e($servidor->situacao()); ?>">
                                </div>
                                <?php if($servidorEAssociado || $servidorDesfiliadoTemporariamente): ?>
                                <div class="form-group col-2">
                                    <label for="matricula">Matrícula</label>
                                    <input type="text" name="matricula" readonly class="form-control-plaintext" value="<?php echo e($matricula->id); ?>">
                                </div>
                                <div class="form-group col-2">
                                    <label for="data_filiacao">Data filiação</label>
                                    <input type="text" name="data_filiacao" readonly class="form-control-plaintext" value="<?php echo e($matricula->data_filiacao->format('d/m/Y')); ?>">
                                </div>
                                <?php elseif($servidorDesfiliadoDefinitivamente): ?>
                                <div class="form-group col-4">
                                    <label for="motivo_desfiliacao">Motivo desfiliação</label>
                                    <input type="text" name="motivo_desfiliacao" readonly class="form-control-plaintext" value="<?php echo e($matricula->motivo_desligamento); ?>">
                                </div>
                                <?php if($matricula->motivo_desligamento->isFalecido()): ?>
                                <div class="form-group col-3">
                                    <label for="data_falecimento_readonly">Data falecimento</label>
                                    <input type="text" name="data_falecimento_readonly" readonly class="form-control-plaintext" value="<?php echo e(optional($servidor->data_falecimento)->format('d/m/Y')); ?>">
                                </div>
                                <?php elseif($matricula->motivo_desligamento->isAny($motivosExoneracao)): ?>
                                <div class="form-group col-3">
                                    <label for="data_publicacao_portaria">Data pub. portaria</label>
                                    </label>
                                    <input type="text" name="data_publicacao_portaria" readonly class="form-control-plaintext" value="<?php echo e(optional($matricula->data_publicacao_portaria)->format('d/m/Y')); ?>">
                                </div>

                                <?php endif; ?>

                                <?php endif; ?>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-6">
                                    <label for="nome">Nome *</label>
                                    <input type="text" autofocus name="nome" maxlength="150" class="form-control <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nome') ?? $servidor->nome); ?>">
                                </div>
                                <div class="form-group col-6">
                                    <label for="nome_social">Nome social</label>
                                    <input type="text" name="nome_social" maxlength="150" class="form-control <?php $__errorArgs = ['nome_social'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nome_social') ?? $servidor->nome_social); ?>">
                                </div>
                                <div class="form-group col-4">
                                    <label for="cpf">CPF *</label>
                                    <input type="text" name="cpf" required maxlength="14" class="cpf form-control <?php $__errorArgs = ['cpf'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('cpf') ?? $servidor->cpf); ?>">
                                </div>
                                <div class="form-group col-4">
                                    <label for="rg">RG</label>
                                    <input type="text" name="rg" maxlength="15" class="form-control <?php $__errorArgs = ['rg'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('rg') ?? $servidor->rg); ?>">
                                </div>
                                <div class="form-group col-4">
                                    <label for="estado_civil">Estado civil</label>
                                    <select name="estado_civil" class="form-control <?php $__errorArgs = ['estado_civil'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value=""></option>
                                        <?php $__currentLoopData = $estadosCivis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estadoCivil): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($estadoCivil->getIndex()); ?>" <?php echo e(optional($servidor->estado_civil)->isEqual($estadoCivil) ? 'selected': ''); ?>><?php echo e($estadoCivil->getValue()); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-3">
                                    <label for="sexo">Sexo</label>
                                    <select name="sexo" class="form-control <?php $__errorArgs = ['sexo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value=""></option>
                                        <?php $__currentLoopData = $sexos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sexo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($sexo->getIndex()); ?>" <?php echo e(optional($servidor->sexo)->isEqual($sexo) ? 'selected': ''); ?>><?php echo e($sexo->getValue()); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-3">
                                    <label for="data_nascimento">Data de nascimento</label>
                                    <input type="text" name="data_nascimento" class="data form-control <?php $__errorArgs = ['data_nascimento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('data_nascimento') ?? optional($servidor->data_nascimento)->format('d/m/Y')); ?>">
                                </div>
                                <div class="form-group col-4">
                                    <label for="naturalidade">Naturalidade</label>
                                    <input type="text" id="naturalidade" name="naturalidade" maxlength="150" class="form-control <?php $__errorArgs = ['naturalidade'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('naturalidade') ?? $servidor->naturalidade); ?>">
                                </div>
                                <div class="form-group col-2">
                                    <label for="naturalidade_uf">Naturalidade/UF</label>
                                    <select name="naturalidade_uf" class="form-control <?php $__errorArgs = ['naturalidade_uf'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="" <?php if(old('naturalidade_uf', $servidor->naturalidade_uf) == null): ?> selected <?php endif; ?>></option>
                                        <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($estado->ufe_sg); ?>" <?php echo e(old('naturalidade_uf', $servidor->naturalidade_uf) == $estado->ufe_sg ? 'selected' : ''); ?>><?php echo e($estado->ufe_sg); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-3" id="div-foto">
                            <img src='<?php echo e($servidor->imagem ? asset("storage/servidores/$servidor->imagem") : ""); ?>' />
                            <input type="hidden" id="hidden-imagem-camera" name="imagem_camera">
                            <input type="hidden" id="hidden-remover-imagem" name="remover_imagem">
                            <div id="div-botoes-foto">
                                <button type="button" id="btn-abrir-captura-foto" class="btn btn-outline-primary btn-sm" alt="Obter foto pela webcam"><i data-feather="camera"></i></button>
                                <button type="button" id="btn-remover-foto" class="btn btn-outline-primary btn-sm" alt="Remover foto"><i data-feather="x"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-3">
                            <label for="nacionalidade">Nacionalidade</label>
                            <input type="text" name="nacionalidade" maxlength="150" class="form-control <?php $__errorArgs = ['nacionalidade'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nacionalidade') ?? $servidor->nacionalidade); ?>">
                        </div>
                        <div class="form-group col-2">
                            <label for="nao_perturbe">Não perturbar</label>
                            <select name="nao_perturbe" class="form-control <?php $__errorArgs = ['nao_perturbe'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="0" <?php if(! old('nao_perturbe', $servidor->nao_perturbe)): ?> selected <?php endif; ?>>NÃO</option>
                                <option value="1" <?php if( old('nao_perturbe', $servidor->nao_perturbe)): ?> selected <?php endif; ?>>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="nivel_ensino">Nível de ensino</label>
                            <select name="nivel_ensino" class="form-control <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nivel_ensino')); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = $niveisEnsino; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nivel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($nivel->getIndex()); ?>" <?php if(old('nivel_ensino', optional($servidor->nivel_ensino)->getIndex()) == $nivel->getIndex()): ?> selected <?php endif; ?>><?php echo e($nivel->getValue()); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-4">
                            <label for="nome_mae">Nome da mãe</label>
                            <input type="text" name="nome_mae" maxlength="150" class="form-control <?php $__errorArgs = ['nome_mae'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nome_mae') ?? $servidor->nome_mae); ?>">
                        </div>
                        <div class="form-group col-3">
                            <label for="nome_pai">Nome do pai</label>
                            <input type="text" name="nome_pai" maxlength="150" class="form-control <?php $__errorArgs = ['nome_pai'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('nome_pai') ?? $servidor->nome_pai); ?>">
                        </div>
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea name="observacoes" class="form-control <?php $__errorArgs = ['observacoes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('observacoes') ?? $servidor->observacoes); ?></textarea>
                        </div>
                    </div>

                    <h5 class="hk-pg-title">
                        Contatos
                    </h5>
                    <hr>
                    <div class="my-10">
                        <button id="btn-incluir-fixo" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone fixo</button>
                        <button id="btn-incluir-celular" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone celular</button>
                        <button id="btn-incluir-email" type="button" class="btn btn-primary"><i data-feather="plus"></i> E-mail</button>
                    </div>
                    <?php echo $__env->make('components.telefones', ['telefones' => $servidor->contatos()->telefones()->get(), 'malaDireta' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('components.emails', ['emails' => $servidor->contatos()->emails()->get(), 'malaDireta' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <h5 class="hk-pg-title">
                        Endereços
                    </h5>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.enderecos.create',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'plus',
                    'label' => 'Incluir',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <div class="form-row">
                        <?php echo $__env->make('components.listagem-endereco', ['enderecos' => $servidor->enderecos], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <h5 class="hk-pg-title">
                        Dados Funcionais
                    </h5>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.registros.create',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'plus',
                    'label' => 'Incluir',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <div class="form-row">
                        <?php echo $__env->make('components.listagem-registros', ['registros' => $servidor->registros], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php if($servidor->trashed()): ?>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'refresh-ccw',
                    'label' => 'Restaurar',
                    'class' => 'btn-primary btn-restaurar-servidor'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php endif; ?>

                    <?php if($servidorEAssociado): ?>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.desfilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Desfiliar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php elseif($servidorDesfiliadoTemporariamente): ?>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.afilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Reafiliar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.desfilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Desfiliar definit.',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php elseif($servidorDesfiliadoDefinitivamente): ?>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.religamento-extraordinario-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Relig. extraordinário',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.afilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Afiliar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php else: ?>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.afilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Afiliar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php endif; ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.dependentes.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'users',
                    'label' => 'Dependentes',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.convenios.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'list',
                    'label' => 'Convênios',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.documentos.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'file',
                    'label' => 'Documentos',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'icon' => 'file-text',
                    'label' => 'Processos',
                    'class' => 'btn-secondary',
                    'route' => 'admin.processos-juridicos.index',
                    'routeParams' => ['pessoa' => $servidor->id, 'tipo' => 'associado']
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.guia-atendimento.create',
                    'routeParams' => ['servidor' => $servidor],
                    'class' => 'btn-secondary',
                    'label' => 'Atender',
                    'icon' => 'clipboard'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.anamnese-atendimento.create-edit',
                    'routeParams' => ['pessoa' => $servidor, 'tipo' => 'associado'],
                    'class' => 'btn-secondary',
                    'label' => 'Anamnese',
                    'icon' => 'clipboard'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.movimentacoes.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'list',
                    'label' => 'Movimentações',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.falecimento-form',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'x',
                    'label' => 'Falecimento',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <?php if(count($todosDocumentosImprimir) > 0): ?>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'printer',
                    'label' => 'Imprimir documentos',
                    'class' => 'btn-secondary',
                    'id' => 'btn-imprimir-documentos',
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php endif; ?>

                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.servidores.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5><?php echo e(session('status')); ?></h5>
            </div>
            <div class="modal-body">
                <p>Servidor deseja se afiliar ao sindicato?</p>
            </div>
            <div class="modal-footer">
                <a href="<?php echo e(route('admin.servidores.afilia-form', ['servidor' => $servidor])); ?>" class="btn btn-primary" id="btn-afilia">Sim</a>
                <button type="button" class="btn btn-secondary" id="btn-nao-afiliar">Não</button>
                <button type="button" class="btn btn-secondary" id="btn-voltar">Voltar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="modal-sucesso-filiacao" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <p><?php echo e(session('status')); ?></p>
            </div>
            <div class="modal-body">
                <p>Atenção: Não se esqueça de imprimir o documento abaixo para assinatura do novo associado</p>

                <ul class="mt-3">
                    <?php $__currentLoopData = $documentosImprimirFiliacao; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $documento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a target="new" href="<?php echo e($documento->url); ?>"><?php echo e($documento->texto); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <li><a target="new" href="<?php echo e(route('admin.formularios.servidores.ficha-inscricao', ['servidor' => $servidor])); ?>">Ficha de Inscrição / Autorização para Descontos</a></li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-endereco" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-endereco">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o endereço?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-excluir-registro" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-registro">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o registro?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-restaurar-servidor" tabindex="-1" role="dialog">
    <form method="POST" id="form-restaurar-servidor" action="<?php echo e(route('admin.servidores.restore', ['servidor' => $servidor])); ?>">
        <?php echo csrf_field(); ?>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente restaurar o servidor?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-impressao-documentos" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <p>Imprimir documentos do servidor</p>
            </div>
            <div class="modal-body">
                <ul>
                    <?php $__currentLoopData = $todosDocumentosImprimir; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $documento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a target="new" href="<?php echo e($documento->url); ?>"><?php echo e($documento->texto); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-termos-assinar" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <p><?php echo e(session('status')); ?></p>
            </div>
            <div class="modal-body">
                <p>Atenção: Imprima os documentos de desligamento do associado e os termos de desligamento dos convênios abaixo:</p>

                <ul class="mt-3">
                    <?php $__currentLoopData = $documentosImprimirDesligamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $documento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a target="new" href="<?php echo e($documento->url); ?>"><?php echo e($documento->texto); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-captura-foto" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Capturar foto</h3>
            </div>
            <div class="modal-body">
                <video autoplay></video>
            </div>
            <div class="modal-footer">
                <button id="btn-captura-foto" type="button" class="btn btn-primary">Capturar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sindserv/resources/views/admin/servidores/edit.blade.php ENDPATH**/ ?>