<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/admin/envio-sms/mensagens-enviadas.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Envio de SMS</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Envio de SMS
        </h4>
    </div>
    <!-- /Title -->

    <?php $__env->startComponent('components.alerts'); ?>
    <?php echo $__env->renderComponent(); ?>
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.button', [
                'route' => 'admin.envio-sms.selecao-contatos-form',
                'icon' => 'plus',
                'label' => 'Escrever',
                'class' => 'btn-primary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Mensagem</th>
                            <th>Enviada em</th>
                            <th>Por</th>
                            <th>Qtde. servidores</th>
                            <th>Filtro utilizado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $mensagens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mensagem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(str_limit($mensagem->mensagem, 50)); ?></td>
                            <td><?php echo e($mensagem->created_at->format('d/m/Y H:i:s')); ?></td>
                            <td><?php echo e($mensagem->enviado_por->name); ?></td>
                            <td><?php echo e($mensagem->qtde_contatos); ?></td>
                            <td><?php echo e($mensagem->tipo_servidor); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sindserv/resources/views/admin/envio-sms/mensagens-enviadas.blade.php ENDPATH**/ ?>