<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/horarios-trabalho/index.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route($routes['trabalhavel']['index']['route'])); ?>"><?php echo e($trabalhavel); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route($routes['trabalhavel']['edit']['route'], $routes['trabalhavel']['edit']['params'])); ?>">Editar</a></li>
        <li class="breadcrumb-item active" aria-current="page">Horários de trabalho</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Horários de trabalho
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <?php $__env->startComponent('components.alerts'); ?>
                <?php echo $__env->renderComponent(); ?>

                <form action="<?php echo e(route($routes['horario']['store']['route'], $routes['horario']['store']['params'])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <table class="table mt-3">
                        <thead>
                            <tr>
                                <th class="col-3">Dia semana</th>
                                <th>Entrada</th>
                                <th>Saída</th>
                                <th>Entrada</th>
                                <th>Saída</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php $__currentLoopData = $diasSemana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $diaSemana): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($diaSemana); ?></td>
                                <td>
                                    <input type="text" class="form-control horario" value='
                                                <?php if(old("horarios.{$diaSemana->getName()}.0.inicio")): ?>)
                                                    <?php echo e(old("horarios.{$diaSemana->getName()}.0.inicio")); ?>

                                                <?php elseif(isset($horarios[$diaSemana->getName()][0])): ?> 
                                                    <?php echo e($horarios[$diaSemana->getName()][0]["inicio"]->format("H:i")); ?>

                                                <?php else: ?> 
                                                    ""
                                                <?php endif; ?>' name='<?php echo e("horarios[{$diaSemana->getName()}][0][inicio]"); ?>'>
                                </td>
                                <td>
                                    <input type="text" class="form-control horario" value='
                                                <?php if(old("horarios.{$diaSemana->getName()}.0.fim")): ?>)
                                                    <?php echo e(old("horarios.{$diaSemana->getName()}.0.fim")); ?>

                                                <?php elseif(isset($horarios[$diaSemana->getName()][0])): ?> 
                                                    <?php echo e($horarios[$diaSemana->getName()][0]["fim"]->format("H:i")); ?>

                                                <?php else: ?> 
                                                    ""
                                                <?php endif; ?>' name='<?php echo e("horarios[{$diaSemana->getName()}][0][fim]"); ?>'>
                                </td>
                                <td>
                                    <input type="text" class="form-control horario" value='
                                                <?php if(old("horarios.{$diaSemana->getName()}.1.inicio")): ?>)
                                                    <?php echo e(old("horarios.{$diaSemana->getName()}.1.inicio")); ?>

                                                <?php elseif(isset($horarios[$diaSemana->getName()][1])): ?> 
                                                    <?php echo e($horarios[$diaSemana->getName()][1]["inicio"]->format("H:i")); ?>

                                                <?php else: ?> 
                                                    ""
                                                <?php endif; ?>' name='<?php echo e("horarios[{$diaSemana->getName()}][1][inicio]"); ?>'>
                                </td>
                                <td>
                                    <input type="text" class="form-control horario" value='
                                                <?php if(old("horarios.{$diaSemana->getName()}.1.fim")): ?>)
                                                    <?php echo e(old("horarios.{$diaSemana->getName()}.1.fim")); ?>

                                                <?php elseif(isset($horarios[$diaSemana->getName()][1])): ?> 
                                                    <?php echo e($horarios[$diaSemana->getName()][1]["fim"]->format("H:i")); ?>

                                                <?php else: ?> 
                                                    ""
                                                <?php endif; ?>' name='<?php echo e("horarios[{$diaSemana->getName()}][1][fim]"); ?>'>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                </form>
            </section>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/horarios-trabalho/index.blade.php ENDPATH**/ ?>