<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/unidades-organizacionais/create-edit.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/telefones.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/emails.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.unidades-organizacionais.index')); ?>">Unidade Organizacional</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar unidade organizacional
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="<?php echo e(route('admin.unidades-organizacionais.update', ['unidade' => $unidade])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <?php $__env->startComponent('components.alerts'); ?>
                    <?php echo $__env->renderComponent(); ?>

                    <input type="hidden" id="hidden-sucesso" value="<?php echo e(session('sucesso')); ?>">
                    <input type="hidden" id="hidden-rota-voltar" value="<?php echo e(session('rotaVoltar')); ?>">

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label for="nome">Nome *</label>
                            <input type="text" autofocus name="nome" maxlength="100" class="form-control <?php $__errorArgs = ['nome'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($unidade->nome); ?>">
                        </div>
                        <div class="form-group col-3">
                            <label for="sigla">Sigla</label>
                            <input type="text" name="sigla" maxlength="15" class="form-control <?php $__errorArgs = ['sigla'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($unidade->sigla); ?>">
                        </div>
                        <div class="form-group col-3">
                            <label for="centro_custo">Centro de custo</label>
                            <input type="text" name="centro_custo" maxlength="11" class="form-control <?php $__errorArgs = ['centro_custo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($unidade->centro_custo); ?>">
                        </div>
                        <?php echo $__env->make('components.endereco', ['container' => 'form-row', 'obrigatorio' => false, 'endereco' => $unidade->enderecos->first()], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div class="form-group col-5">
                            <label for="hierarquia">Hierarquia</label>
                            <input type="text" readonly name="hierarquia" class="form-control-plaintext" value="<?php echo e($unidade->hierarquiaExtenso()); ?>">
                        </div>
                        <?php echo $__env->make('components.telefones', ['telefones' => $unidade->contatos()->telefones()->get(), 'malaDireta' => true, 'container' => 'form-row col-12'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <hr>
                    <?php $__env->startComponent('components.button', [
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <button id="btn-incluir-fixo" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone fixo</button>
                    <button id="btn-incluir-celular" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone celular</button>
                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.unidades-organizacionais.transferir-form',
                    'routeParams' => ['unidade' => $unidade],
                    'icon' => 'move',
                    'label' => 'Transferir',
                    'class' => 'btn-primary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php if($unidade->superior): ?>
                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.unidades-organizacionais.edit',
                    'routeParams' => ['unidade' => $unidade->superior],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php else: ?>
                    <?php $__env->startComponent('components.button', [
                    'route' => 'admin.unidades-organizacionais.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ]); ?>
                    <?php echo $__env->renderComponent(); ?>
                    <?php endif; ?>
                </form>
            </section>
            <section class="hk-sec-wrapper">
                <div class="hk-pg-header">
                    <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
                        Unidades abaixo
                    </h4>
                </div>
                <?php $__env->startComponent('components.button', [
                'route' => 'admin.unidades-organizacionais-create-subordinada',
                'routeParams' => ['superior' => $unidade],
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ]); ?>
                <?php echo $__env->renderComponent(); ?>

                <?php echo $__env->make('admin.unidades-organizacionais.listagem', ['unidades' => $unidade->subordinada()->paginate()], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </section>



        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5><?php echo e(session('status')); ?></h5>
            </div>
            <div class="modal-body">
                <p>Deseja continuar e editar a unidade ou voltar para página anterior?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="btn-continuar">Continuar e editar</button>
                <button type="button" class="btn btn-secondary" id="btn-voltar">Voltar</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/unidades-organizacionais/edit.blade.php ENDPATH**/ ?>