<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
  <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO'])); ?>">Atendimento Jurídico</a></li>
    <?php if(request()->tipo == 'associado'): ?>
            <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.servidores.edit', ['servidor' => request()->pessoa])); ?>"><?php echo e($pessoa->nome); ?></a></li>
        <?php else: ?>
            <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.funcionarios.edit', ['funcionario' => request()->pessoa])); ?>"><?php echo e($pessoa->nome); ?></a></li>
        <?php endif; ?>
    <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('admin.processos-juridicos.index', ['tipo' => request()->tipo, 'pessoa' => request()->pessoa])); ?>">Processos</a></li>
    <li class="breadcrumb-item active" aria-current="page">Incluir</li>
  </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
  <!-- Title -->
  <div class="hk-pg-header">
    <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
      Incluir processo
    </h4>
  </div>
  <!-- /Title -->
  <div class="row">
    <div class="col-xl-12">
      <section class="hk-sec-wrapper">
        <form action="<?php echo e(route('admin.processos-juridicos.store', ['tipo' => request()->tipo, 'pessoa' => request()->pessoa])); ?>" method="post">
          <?php echo csrf_field(); ?>
          <?php $__env->startComponent('components.alerts'); ?>
          <?php echo $__env->renderComponent(); ?>

          <input type="hidden" name="agendamento" value="<?php echo e(request()->agendamento); ?>">

          <div class="form-row">
            <div class="form-group col-2">
              <label for="numero">Número *</label>
              <input type="text" required autofocus name="numero" maxlength="30" class="form-control <?php $__errorArgs = ['numero'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('numero')); ?>">
            </div>
            <div class="form-group col-2">
              <label for="vara">Vara</label>
              <input type="text" name="vara" maxlength="10" data-mask="0999999999" data-mask-reverse="true" data-mask-clearifnotmatch="true" class="form-control <?php $__errorArgs = ['vara'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('vara')); ?>">
            </div>
            <div class="form-group col-4">
              <label for="competencia_id">Competência *</label>
              <select name="competencia_id" class="form-control">
                <?php $__currentLoopData = $competencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $competencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($competencia->id); ?>" <?php if(old('competencia_id')==$competencia->id): ?> selected <?php endif; ?>><?php echo e($competencia->descricao); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="form-group col-4">
              <label for="tipo_acao_id">Tipo *</label>
              <select name="tipo_acao_id" class="form-control">
                <?php $__currentLoopData = $tiposAcoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($tipo->id); ?>" <?php if(old('tipo_acao_id')==$tipo->id): ?> selected <?php endif; ?>><?php echo e($tipo->descricao); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="form-group col-3">
              <label for="resultado">Resultado</label>
              <select name="resultado" class="form-control">
                <option value=""></option>
                <?php $__currentLoopData = $resultados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resultado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($resultado->getIndex()); ?>" <?php if(old('resultado')==$resultado->getIndex()): ?> selected <?php endif; ?>><?php echo e($resultado->getValue()); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="form-group col-2">
              <label for="extinto">Extinto *</label>
              <select required name="extinto" class="form-control">
                <option value="0" <?php if(! old('extinto')): ?> selected <?php endif; ?>>NÃO</option>
                <option value="1" <?php if(old('extinto')): ?> selected <?php endif; ?>>SIM</option>
              </select>
            </div>
            <div class="form-group col-2">
              <label for="pago">Pago *</label>
              <select required name="pago" class="form-control">
                <option value="0" <?php if(! old('pago')): ?> selected <?php endif; ?>>NÃO</option>
                <option value="1" <?php if(old('pago')): ?> selected <?php endif; ?>>SIM</option>
              </select>
            </div>
            <div class="form-group col-3">
              <label for="valor_pago">Valor pago</label>
              <input type="text" name="valor_pago" class="form-control <?php $__errorArgs = ['valor_pago'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" data-mask="###.##0,00" data-mask-reverse="true" data-mask-clearifnotmatch="true" value="<?php echo e(old('valor_pago')); ?>">
            </div>
            <div class="form-group col-2">
              <label for="data_pagamento">Data pagamento</label>
              <input type="text" name="data_pagamento" class="form-control <?php $__errorArgs = ['data_pagamento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" data-mask="00/00/0000" data-mask-clearifnotmatch="true" value="<?php echo e(old('data_pagamento')); ?>">
            </div>
            <div class="form-group col-12">
              <label for="anotacoes">Anotações</label>
              <textarea name="anotacoes" class="form-control" rows=5><?php echo e(old('anotacoes')); ?></textarea>
            </div>
          </div>
          <hr>
          <?php $__env->startComponent('components.button', [
          'icon' => 'save',
          'label' => 'Salvar',
          'class' => 'btn-primary'
          ]); ?>
          <?php echo $__env->renderComponent(); ?>
          <?php $__env->startComponent('components.button', [
          'route' => 'admin.processos-juridicos.index',
          'routeParams' => ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'agendamento' => request()->agendamento],
          'icon' => 'arrow-left',
          'label' => 'Voltar',
          'class' => 'btn-secondary'
          ]); ?>
          <?php echo $__env->renderComponent(); ?>
        </form>
      </section>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gabriel/repos/sindserv/resources/views/admin/processos-juridicos/create.blade.php ENDPATH**/ ?>