<?php
$container = $container ?? 'col-12 row';
$obrigatorio = $obrigatorio ?? false;
$malaDireta = $malaDireta ?? false;
$malaDiretaChecked = $malaDiretaChecked ?? false;
?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/admin/endereco.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<input type="hidden" id="hidden-url-logradouro-api-cep" value="<?php echo e(route('api.logradouro-api.busca-cep')); ?>">
<div class="<?php echo e($container); ?> endereco">
    <div class="col-3">
        <label for="cep">CEP <?php echo e($obrigatorio ? '*' : ''); ?></label>
        <div class="input-group">
            <input type="text" id="text-cep" data-mask="00000-000" data-mask-clearifnotmatch="true" <?php echo e($obrigatorio ? 'required' : ''); ?> name="cep" maxlength="8" class="form-control cep <?php $__errorArgs = ['cep'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('cep') ?? $endereco->cep ?? ''); ?>">
            <div class="input-group-append">
                <button class="btn btn-outline-secondary" type="button" id="btn-busca-cep"><i data-feather="search"></i></button>
            </div>
        </div>
    </div>
    <div class="form-group col-4">
        <label for="logradouro">Logradouro <?php echo e($obrigatorio ? '*' : ''); ?></label>
        <input type="text" <?php echo e($obrigatorio ? 'required' : ''); ?> id="text-logradouro" name="logradouro" maxlength="150" class="form-control logradouro <?php $__errorArgs = ['logradouro'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('logradouro') ?? $endereco->logradouro ?? ''); ?>">
    </div>
    <div class="form-group col-2">
        <label for="numero">Número <?php echo e($obrigatorio ? '*' : ''); ?></label>
        <input type="text" <?php echo e($obrigatorio ? 'required' : ''); ?> id="text-numero" name="numero" maxlength="150" class="form-control numero <?php $__errorArgs = ['numero'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('numero') ?? $endereco->numero ?? ''); ?>">
    </div>
    <div class="form-group col-3">
        <label for="complemento">Complemento</label>
        <input type="text" name="complemento" maxlength="50" class="form-control complemento_endereco <?php $__errorArgs = ['complemento'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('complemento') ?? $endereco->complemento ?? ''); ?>">
    </div>
    <div class="form-group col-3">
        <label for="bairro">Bairro <?php echo e($obrigatorio ? '*' : ''); ?></label>
        <input type="text" <?php echo e($obrigatorio ? 'required' : ''); ?> id="text-bairro" name="bairro" maxlength="50" class="form-control bairro <?php $__errorArgs = ['bairro'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('bairro') ?? $endereco->bairro ?? ''); ?>">
    </div>
    <div class="form-group col-4">
        <label for="cidade">Cidade <?php echo e($obrigatorio ? '*' : ''); ?></label>
        <input type="text" <?php echo e($obrigatorio ? 'required' : ''); ?> id="text-cidade" name="cidade" maxlength="100" class="form-control cidade <?php $__errorArgs = ['cidade'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('cidade') ?? $endereco->cidade ?? ''); ?>">
    </div>
    <div class="form-group col-2">
        <label for="estado">Estado <?php echo e($obrigatorio ? '*' : ''); ?></label>
        <select name="estado" <?php echo e($obrigatorio ? 'required' : ''); ?> id="select-estado" class="form-control estado <?php $__errorArgs = ['estado'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
            <?php
            $estadoSelecionado = old('estado', 'SP') ?? optional($endereco->estado);
            ?>
            <?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $estado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($estado->ufe_sg); ?>" <?php echo e($estadoSelecionado == $estado->ufe_sg ? 'selected' : ''); ?>><?php echo e($estado->ufe_sg); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="form-group col-3">
        <label for="observacoes_endereco">Obs. endereço</label>
        <input type="text" name="observacoes_endereco" maxlength="100" class="form-control observacoes_endereco <?php $__errorArgs = ['observacoes_endereco'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('observacoes_endereco') ?? $endereco->observacoes ?? ''); ?>">
    </div>
    <?php if($malaDireta): ?>
    <div class="form-check col-4">
        <label for="check-mala-direta" class="">
            Enviar mala direta?
        </label>
        <input type="checkbox" id="check-mala-direta" name="aceita_mala_direta" <?php echo e($malaDiretaChecked ? 'checked' : ''); ?>>
    </div>
    <?php endif; ?>
</div>
<div class="modal fade" id="modal-busca-logradouro" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
        <input type="hidden" id="hidden-url-busca-logradouro-api" value="<?php echo e(route('api.logradouro-api.busca-logradouro')); ?>">
        <?php echo csrf_field(); ?>
        <div class="modal-content">
            <div class="modal-header">
                <h4>Busca de logradouro</h4>
            </div>
            <div class="modal-body">
                <div id="div-alert" class="alert alert-danger alert-dismissible" role="alert">
                    <p></p>
                </div>

                <div class="form-row">
                    <div class="form-group col-10">
                        <label for="busca-logradouro">Logradouro *</label>
                        <input type="text" id="text-busca-logradouro" name="busca-logradouro" maxlength="150" class="form-control">
                    </div>
                    <div class="form-group col-2">
                        <label for="busca-numero">Número</label>
                        <input type="text" id="text-busca-numero" name="busca-numero" maxlength="150" class="form-control numero <?php $__errorArgs = ['numero'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    </div>
                </div>
                <div class="form-row" id="div-resultado">
                    <table class="table mt-3" id="table-resultado">
                        <thead>
                            <tr>
                                <th>Logradouro</th>
                                <th>Bairro</th>
                                <th>Cidade</th>
                                <th>Estado</th>
                                <th>CEP</th>
                                <th class="w-25">Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-busca-logradouro" class="btn btn-primary">Buscar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div><?php /**PATH /var/www/html/sindserv/resources/views/components/endereco.blade.php ENDPATH**/ ?>