<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name') }}</title>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->

    <!-- Favicon -->
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="icon" href="favicon.ico" type="image/x-icon">

    <!-- Toggles CSS -->
    <link href="{{ asset('vendors/jquery-toggles/css/toggles.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('vendors/jquery-toggles/css/themes/toggles-light.css') }}" rel="stylesheet" type="text/css">

    <!-- Toastr CSS -->
    <link href="{{ asset('vendors/jquery-toast-plugin/dist/jquery.toast.min.css') }}" rel="stylesheet" type="text/css">

    <!-- Custom CSS -->
    <link href="{{ asset('brunette-theme/css/style.css') }}" rel="stylesheet" type="text/css">

    <!-- Base CSS -->
    <link href="{{ asset('css/admin/app.css') }}" rel="stylesheet" type="text/css">
    @stack('css')
</head>

<body>
    <!-- Preloader -->
    <div class="preloader-it">
        <div class="loader-pendulums"></div>
    </div>
    <!-- /Preloader -->

    <!-- HK Wrapper -->
    <div class="hk-wrapper hk-vertical-nav">

        <!-- Top Navbar -->
        <nav class="navbar navbar-expand-xl navbar-light fixed-top hk-navbar">
            <a id="navbar_toggle_btn" class="navbar-toggle-btn nav-link-hover" href="javascript:void(0);"><span class="feather-icon"><i data-feather="menu"></i></span></a>
            <a class="navbar-brand" href="{{ route('admin.home') }}">
                {{ config('app.name') }}
            </a>
            <ul class="navbar-nav hk-navbar-content">
                <li class="nav-item dropdown dropdown-authentication">
                    <a class="nav-link dropdown-toggle no-caret" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="media">
                            <div class="media-body">
                                <span>{{ Auth::user()->name }}<i class="zmdi zmdi-chevron-down"></i></span>
                            </div>
                        </div>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right" data-dropdown-in="flipInX" data-dropdown-out="flipOutX">
                        <a class="dropdown-item" href="{{ route('admin.perfil.index') }}"><i class="dropdown-icon zmdi zmdi-account"></i><span>Perfil</span></a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                            <i class="dropdown-icon zmdi zmdi-power"></i>
                            Sair
                        </a>

                        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                            @csrf
                        </form>
                    </div>
                </li>
            </ul>
        </nav>
        <!-- /Top Navbar -->

        <!-- Vertical Nav -->
        <nav class="hk-nav hk-nav-light">
            <a href="javascript:void(0);" id="hk_nav_close" class="hk-nav-close"><span class="feather-icon"><i data-feather="x"></i></span></a>
            <div class="nicescroll-bar">
                <div class="navbar-nav-wrap">
                    <ul class="navbar-nav flex-column">
                        <li class="nav-item active">
                            <a class="nav-link" href="{{ route('admin.home') }}">
                                <span class="feather-icon"><i data-feather="home"></i></span>
                                <span class="nav-link-text">Início</span>
                            </a>
                        </li>
                        @role('admin')
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin.servidores.index') }}">
                                <span class="feather-icon"><i data-feather="users"></i></span>
                                <span class="nav-link-text">Servidores</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin.dependentes.busca') }}">
                                <span class="feather-icon"><i data-feather="users"></i></span>
                                <span class="nav-link-text">Dependentes</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin.funcionarios.index') }}">
                                <span class="feather-icon"><i data-feather="users"></i></span>
                                <span class="nav-link-text">Funcionários</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin.agenda-diretoria.index') }}">
                                <span class="feather-icon"><i data-feather="calendar"></i></span>
                                <span class="nav-link-text">Agenda da diretoria</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin.prestadores-servicos.index') }}">
                                <span class="feather-icon"><i data-feather="briefcase"></i></span>
                                <span class="nav-link-text">Prestadores de serviços</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#drop-financeiro">
                                <span class="feather-icon"><i data-feather="dollar-sign"></i></span>
                                <span class="nav-link-text">Financeiro</span>
                            </a>
                            <ul id="drop-financeiro" class="nav flex-column collapse collapse-level-1">
                                <li class="nav-item">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.contas-pagar-receber.index') }}">Contas a pagar/receber</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.movimento-caixa.index') }}">Movimento de caixa</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.planos-contas.index') }}">Planos contas</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#drop-atendimento-odontologico">
                                <span class="feather-icon"><i data-feather="clipboard"></i></span>
                                <span class="nav-link-text">Atendimento Odontológico</span>
                            </a>
                            <ul id="drop-atendimento-odontologico" class="nav flex-column collapse collapse-level-1">
                                <li class="nav-item">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'ODONTOLOGICO']) }}">Agenda</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.agendamentos-atendimentos.busca', ['tipo' => 'ODONTOLOGICO']) }}">Busca</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.atendimentos-odontologicos.index') }}">Atendimentos</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#drop-atendimento-juridico">
                                <span class="feather-icon"><i data-feather="clipboard"></i></span>
                                <span class="nav-link-text">Atendimento Jurídico</span>
                            </a>
                            <ul id="drop-atendimento-juridico" class="nav flex-column collapse collapse-level-1">
                                <li class="nav-item">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.agendamentos-atendimentos.index', ['tipo' => 'JURIDICO']) }}">Agenda</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.agendamentos-atendimentos.busca', ['tipo' => 'JURIDICO']) }}">Busca</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin.envio-sms.mensagens-enviadas') }}">
                                <span class="feather-icon"><i data-feather="send"></i></span>
                                <span class="nav-link-text">Envio de SMS</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin.exportacao-csv.index') }}">
                                <span class="feather-icon"><i data-feather="file-text"></i></span>
                                <span class="nav-link-text">Exportação de CSV</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#drop-guia-atendimento">
                                <span class="feather-icon"><i data-feather="clipboard"></i></span>
                                <span class="nav-link-text">Guia de atendimento</span>
                            </a>
                            <ul id="drop-guia-atendimento" class="nav flex-column collapse collapse-level-1">
                                <li class="nav-item">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.guia-atendimento.buscar') }}">Atender</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.guia-atendimento.index') }}">Atendimentos feitos</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#drop-convenios">
                                <span class="feather-icon"><i data-feather="activity"></i></span>
                                <span class="nav-link-text">Convênios</span>
                            </a>
                            <ul id="drop-convenios" class="nav flex-column collapse collapse-level-1">
                                <li class="nav-item">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.convenios.index') }}">Convênios</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.especialidades-convenios.index') }}">Especialidades</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#drop-sistema">
                                <span class="feather-icon"><i data-feather="settings"></i></span>
                                <span class="nav-link-text">Sistema</span>
                            </a>
                            <ul id="drop-sistema" class="nav flex-column collapse collapse-level-1">
                                <li class="nav-item">
                                    <ul class="nav flex-column">
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.usuarios.index') }}">Usuários</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.auditoria.index') }}">Logs de auditoria</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.unidades-organizacionais.index') }}">Unidades Organizacionais</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.feriados.index') }}">Feriados</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.perguntas-anamnese.index') }}">Perguntas da Anamnese</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.motivos-cancelamentos-agendamentos.index') }}">Motivos de canc. Agendamento</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.motivos-registros-atendimento.index') }}">Motivos de reg. Atendimento</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.motivos-filiacao.index') }}">Motivos de filiação</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.tipos-documentos.index') }}">Tipos de documentos</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.tipos-acoes-processos.index') }}">Tipos de ações de processos</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.competencias-processos.index') }}">Competências de processos</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.servicos-atendimentos.horarios-trabalho.index', ['servico' => 1]) }}">Horários atendimento Jurídico</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.mensalidades.index') }}">Mensalidades</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.cargos.index') }}">Cargos</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.configuracoes.index') }}">Configurações</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.niveis-salariais.index') }}">Níveis Salariais</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" href="{{ route('admin.geracao-carteirinha.index') }}">Geração de carteirinha</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        @endrole
                    </ul>
                </div>
            </div>
        </nav>
        <div id="hk_nav_backdrop" class="hk-nav-backdrop"></div>
        <!-- /Vertical Nav -->

        <!-- Main Content-->
        <div class="hk-pg-wrapper">
            @yield('content')
        </div>
        <!-- /Main Content-->

    </div>
    <!-- /HK Wrapper -->

    <!-- JavaScript -->
    <script src="{{ asset('js/jquery-3.3.1.min.js') }}"></script>
    <script src="{{ asset('js/popper.min.js') }}"></script>
    <script src="{{ asset('js/bootstrap.min.js') }}"></script>

    <!-- Slimscroll JavaScript -->
    <script src="{{ asset('brunette-theme/js/jquery.slimscroll.js') }}"></script>

    <!-- Fancy Dropdown JS -->
    <script src="{{ asset('brunette-theme/js/dropdown-bootstrap-extended.js') }}"></script>

    <!-- FeatherIcons JavaScript -->
    <script src="{{ asset('brunette-theme/js/feather.min.js') }}"></script>

    <!-- Toggles JavaScript -->
    <script src="{{ asset('vendors/jquery-toggles/toggles.min.js') }}"></script>
    <script src="{{ asset('brunette-theme/js/toggle-data.js') }}"></script>

    <!-- Counter Animation JavaScript -->
    <script src="{{ asset('vendors/waypoints/lib/jquery.waypoints.min.js') }}"></script>
    <script src="{{ asset('vendors/jquery.counterup/jquery.counterup.min.js') }}"></script>

    <!-- Toastr JS -->
    <script src="{{ asset('vendors/jquery-toast-plugin/dist/jquery.toast.min.js') }}"></script>

    <!-- Init JavaScript -->
    <script src="{{ asset('brunette-theme/js/init.js') }}"></script>

    <script src="{{ asset('js/admin/geral.js') }}"></script>

    @stack('js')
</body>

</html>
