@push('js')
    <script src="{{ asset('js/admin/telefones.js') }}"></script>
@endpush

@php
    $name = $name ?? 'telefone';
    $malaDireta = $malaDireta ?? false;
    $container = $container ?? 'form-row';
@endphp
<div class="div-telefones {{ $container }}">
    @foreach ($telefones as $i => $telefone)
        @if ($telefone->eTelefoneFixo())
            @include('components.telefone', ['name' => "{$name}[$i]", 'tipoTelefone' => 'fixo', 
                'valor' => old("$name.$i.numero") ?? $telefone->valor, 'observacoes' => old("$name.$i.observacoes") ?? $telefone->observacoes])
        @else
            @include('components.telefone', ['name' => "{$name}[$i]", 'tipoTelefone' => 'celular', 'malaDireta' => $malaDireta,
                'valor' => old("$name.$i.numero") ?? $telefone->valor, 'malaDiretaChecked' => $telefone->aceita_mala_direta,
                'observacoes' => old("$name.$i.observacoes") ?? $telefone->observacoes])
        @endif
    @endforeach
</div>