
@php
$form = $form ?? 'form-servidor';
@endphp

<div class="modal fade" id="modal-logradouro-lotacao" tabindex="-1">
    <div class="modal-dialog modal-dialog-scrollable modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4>Lotação Servidor</h4>
            </div>
            <div class="modal-body">
                <div id="div-alert-lotacao" class="alert alert-danger alert-dismissible" role="alert">
                    <p></p>
                </div>
                <div class="form-row">
                    <input type="hidden" id="hidden-url-logradouro-api-cep" value="{{ route('api.logradouro-api.busca-cep') }}">
                    <div class="col-3">
                        <label for="cep_lotacao">CEP *</label>
                        <div class="input-group">
                            <input type="text" id="text-cep-lotacao" form="{{ $form }}" data-mask="00000-000" data-mask-clearifnotmatch="true" name="cep_lotacao" value="{{ old('cep_lotacao') }}" maxlength="8" class="form-control">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary" type="button" id="btn-busca-cep-lotacao"><i data-feather="search"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-4">
                        <label for="logradouro_lotacao">Logradouro *</label>
                        <input type="text" id="text-logradouro-lotacao" form="{{ $form }}" name="logradouro_lotacao" maxlength="150" class="form-control" value="{{ old('logradouro_lotacao') }}">
                    </div>
                    <div class="form-group col-2">
                        <label for="numero_lotacao">Número *</label>
                        <input type="text" id="text-numero-lotacao" form="{{ $form }}" name="numero_lotacao" maxlength="150" class="form-control" value="{{ old('numero_lotacao') }}">
                    </div>
                    <div class="form-group col-3">
                        <label for="bairro_lotacao">Bairro *</label>
                        <input type="text" id="text-bairro-lotacao" form="{{ $form }}" name="bairro_lotacao" maxlength="50" class="form-control" value="{{ old('bairro_lotacao')}}">
                    </div>
                    <div class="form-group col-4">
                        <label for="cidade_lotacao">Cidade *</label>
                        <input type="text" id="text-cidade-lotacao" form="{{ $form }}" name="cidade_lotacao" maxlength="100" class="form-control" value="{{ old('cidade_lotacao')}}">
                    </div>
                    <div class="form-group col-2">
                        <label for="estado_lotacao">Estado *</label>
                        <select name="estado_lotacao" form="{{ $form }}" id="select-estado-lotacao" class="form-control estado">
                            @php
                            $estadoSelecionado = old('estado_lotacao', 'SP')
                            @endphp
                            @foreach ($estados as $estado)
                            <option value="{{ $estado->ufe_sg }}" {{ $estadoSelecionado == $estado->ufe_sg ? 'selected' : '' }}>{{ $estado->ufe_sg }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-6">
                        <label for="observacoes_lotacao">Obs. endereço</label>
                        <input type="text" name="observacoes_lotacao" form="{{ $form }}" maxlength="100" class="form-control" value="{{ old('observacoes_lotacao') }}">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-seleciona-logradouro-lotacao" class="btn btn-primary">Selecionar</button>
                <button type="button" id="btn-cancelar-selecao-logradouro" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>