<table class="table mt-3">
    <thead>
        <tr>
            <th>CEP</th>
            <th>Logradouro</th>
            <th>Bairro</th>
            <th>Número</th>
            <th>Cidade</th>
            <th>Mala direta</th>
            <th class="w-25">Ação</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($enderecos as $endereco)
        <tr>
            <td>{{ $endereco->cep }}</td>
            <td>{{ $endereco->logradouro }}</td>
            <td>{{ $endereco->bairro }}</td>
            <td>{{ $endereco->numero != 0 ? $endereco->numero : 'S/N' }}</td>
            <td>{{ $endereco->cidade }}</td>
            <td>{{ $endereco->aceita_mala_direta ? 'SIM' : 'NÃO' }}</td>
            <td>
                @button([
                'route' => 'admin.servidores.enderecos.edit',
                'routeParams' => ['servidor' => $servidor, 'endereco' => $endereco],
                'class' => 'btn-primary',
                'label' => 'Visualizar/Editar',
                'icon' => 'edit'
                ])
                @endbutton
                @button([
                'class' => 'btn-danger btn-excluir-endereco',
                'icon' => 'x',
                'label' => 'Excluir',
                'route' => 'admin.servidores.enderecos.destroy',
                'routeParams' => ['servidor' => $servidor, 'endereco' => $endereco],
                ])
                @endbutton
            </td>
        </tr>
        @endforeach
    </tbody>
</table>