<table class="table mt-3">
    <thead>
        <tr>
            <th>Descrição</th>
            <th>Ação</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($anexos as $anexo)
        <tr>
            <td>{{ $anexo->descricao }}</td>
            <td>
                @button([
                'route' => 'admin.anexos-processos-juridicos.edit',
                'routeParams' => ['idProcesso' => $processo->id, 'pessoa' => request()->pessoa, 'tipo' => request()->tipo, 'id' => $anexo->id],
                'class' => 'btn-primary',
                'label' => 'Visualizar/Editar',
                'icon' => 'edit'
                ])
                @endbutton
                @button([
                'route' => 'admin.anexos-processos-juridicos.download',
                'routeParams' => ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'idProcesso' => $processo->id, 'id' => $anexo->id],
                'icon' => 'download',
                'label' => 'Download',
                'class' => 'btn-primary'
                ])
                @endbutton
                @button([
                'class' => 'btn-danger btn-excluir',
                'icon' => 'x',
                'label' => 'Excluir',
                'route' => 'admin.anexos-processos-juridicos.destroy',
                'routeParams' => ['idProcesso' => $processo->id, 'pessoa' => request()->pessoa, 'tipo' => request()->tipo, 'id' => $anexo->id],
                ])
                @endbutton
            </td>
        </tr>
        @endforeach
    </tbody>
</table>