@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/usuarios/perfis/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page">Usuários</li>
        <li class="breadcrumb-item" aria-current="page">{{ $usuario->name }}</li>
        <li class="breadcrumb-item" aria-current="page">Perfis</li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir perfil
        </h4>
    </div>
    <!-- /Title -->

    <form action="{{ route('admin.usuarios.perfis.store', ['usuario' => $usuario]) }}" method="post">
        @csrf
        @alerts
        @endalerts

        <section class="hk-sec-wrapper">
            <div class="form-row">
                <div class="form-group col-12 col-md-5">
                    <label for="name">Perfil *</label>
                    <select name="perfil" id="perfil" class="form-control">
                        @foreach ($perfis as $perfil)
                            <option value="{{ $perfil->name }}">{{ Str::ucfirst($perfil->name) }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            @button([
            'icon' => 'save',
            'label' => 'Salvar',
            'class' => 'btn-primary'
            ])
            @endbutton
            @button([
            'route' => 'admin.usuarios.index',
            'icon' => 'arrow-left',
            'label' => 'Voltar',
            'class' => 'btn-secondary'
            ])
            @endbutton
        </section>
    </form>
</div>
@endsection