@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/usuarios/alterar-senha.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.usuarios.index') }}">Usuários</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir Usuário
        </h4>
    </div>
    <!-- /Title -->

    <form action="{{ route('admin.usuarios.store') }}" method="post">
        @csrf
        @alerts
        @endalerts

        <section class="hk-sec-wrapper">
            <div class="form-row">
                <div class="form-group col-12 col-md-4">
                    <label for="name">Nome *</label>
                    <input type="text" autofocus name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}">
                </div>
                <div class="form-group col-12 col-md-4">
                    <label for="email">E-mail *</label>
                    <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email') }}">
                </div>
                <div class="form-group col-12 col-md-4">
                    <label for="funcionario_id">Funcionário</label>
                    <select name="funcionario_id" class="form-control @error('funcionario_id') is-invalid @enderror">
                        <option value=""></option>
                        @foreach ($funcionarios as $funcionario)
                        <option value="{{ $funcionario->id }}">{{ $funcionario->nome }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-12 col-md-4">
                    <label for="prestador_servico_id">Prestador</label>
                    <select name="prestador_servico_id" class="form-control @error('prestador_servico_id') is-invalid @enderror">
                        <option value=""></option>
                        @foreach ($prestadores as $prestador)
                        <option value="{{ $prestador->id }}">{{ $prestador->nome }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group col-12 col-md-3">
                    <label for="password">Senha (min. 8 caracteres) *</label>
                    <input type="password" required id="password" name="password" class="form-control @error('password') is-invalid @enderror" value="{{ old('password') }}">
                </div>
                <div class="form-group col-12 col-md-3">
                    <label for="password_confirmation">Confirmação *</label>
                    <input required type="password" id="password_confirmation" name="password_confirmation" class="form-control @error('password_confirmation') is-invalid @enderror" value="{{ old('password_confirmation') }}">
                </div>
            </div>
            @button([
            'icon' => 'save',
            'label' => 'Salvar',
            'class' => 'btn-primary'
            ])
            @endbutton
            @button([
            'route' => 'admin.usuarios.index',
            'icon' => 'arrow-left',
            'label' => 'Voltar',
            'class' => 'btn-secondary'
            ])
            @endbutton
        </section>
    </form>
</div>
@endsection