@push('js')
<script src="{{ asset('js/admin/unidades-organizacionais/listagem-transferencia.js') }}"></script>
@endpush

<table class="table mt-3">
    <thead>
        <tr>
            <th>Nome</th>
            <th>Sigla</th>
            <th>Hierarquia</th>
            <th>Centro de custo</th>
            <th class="w-25">Ação</th>
        </tr>
    </thead>
    <tbody>
        @if ($unidadeTransferir->superior)
        <tr>
            <td colspan="4">(RAIZ)</td>
            <td>
                @button([
                'class' => 'btn-primary btn-transferir-unidade',
                'icon' => 'move',
                'label' => 'Selecionar',
                'route' => 'admin.unidades-organizacionais.transferir',
                'routeParams' => ['unidadeTransferir' => $unidadeTransferir],
                ])
                @endbutton
            </td>
        </tr>
        @endif
        @foreach ($unidades as $unidade)
        <tr>
            <td>{{ $unidade->nome }}</td>
            <td>{{ $unidade->sigla }}</td>
            <td>{{ $unidade->hierarquiaExtenso() }}</td>
            <td>{{ $unidade->centro_custo }}</td>
            <td>
                @button([
                'class' => 'btn-primary btn-transferir-unidade',
                'icon' => 'move',
                'label' => 'Selecionar',
                'route' => 'admin.unidades-organizacionais.transferir',
                'routeParams' => ['unidadeDestino' => $unidade, 'unidadeTransferir' => $unidadeTransferir],
                ])
                @endbutton
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
<div class="modal fade" id="modal-transferir-unidade" tabindex="-1" role="dialog">
    <form method="POST" id="form-transferir-unidade">
        @csrf
        @method('PUT')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente transferir a unidade "{{ $unidade->nome }}" para a unidade selecionada?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
