@extends('layouts.admin')

@push('css')
<link href="{{ asset('css/admin/servidores-create-edit.css') }}" rel="stylesheet" type="text/css">
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Religamento extraordinário</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Religamento extraordinário de servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.servidores.religamento-extraordinario', ['servidor' => $servidor]) }}" method="post">
                    @csrf

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="matricula">Matrícula</label>
                            <input type="text" name="matricula" maxlength="100" readonly class="form-control-plaintext" value="{{ $matricula->id }}">
                        </div>
                        <div class="form-group col-8">
                            <label for="motivo_religamento_extraordinario">Motivo *</label>
                            <input type="text" autofocus required name="motivo_religamento_extraordinario" maxlength="100" class="form-control @error('motivo_religamento_extraordinario') is-invalid @enderror" value="{{ old('motivo_religamento_extraordinario') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="data_religamento_extraordinario">Data *</label>
                            <input type="text" required name="data_religamento_extraordinario" data-mask="00/00/0000" class="form-control @error('data_religamento_extraordinario') is-invalid @enderror" value="{{ old('data_religamento_extraordinario', today()->format('d/m/Y')) }}">
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Religar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection