@extends('layouts.admin')

@push('css')
<link href="{{ asset('vendors/select2/dist/css/select2.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('css/admin/registros-servidores-create-edit.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('vendors/select2/dist/js/select2.full.min.js') }}"></script>
<script src="{{ asset('js/admin/servidores/registros/create-edit.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidor</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir registro</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Incluir registro
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form id="form-registro" action="{{ route('admin.servidores.registros.store', ['servidor' => $servidor]) }}" method="post">
                    @csrf
                    @alerts
                    @endalerts

                    <input type="hidden" id="hidden-url-api-endereco-uor" value="{{ url('admin/servidores/api/endereco-uor') }}">
                    <input type="hidden" name="usar_endereco_unidade" id="hidden-usar_endereco_unidade" value="{{ old('usar_endereco_unidade', '1') }}">

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="numero_registro">Número *</label>
                            <input type="text" required autofocus name="numero_registro" maxlength="6" class="form-control registro @error('numero_registro') is-invalid @enderror" value="{{ old('numero_registro') }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="regime">Regime *</label>
                            <select required id="select-regime" name="regime" class="form-control @error('regime') is-invalid @enderror">
                                @foreach ($regimes as $regime)
                                <option value="{{ $regime->getIndex() }}" @if (old('regime')==$regime->getIndex()) selected @endif>{{ $regime->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="data_admissao">Data de admissão *</label>
                            <input type="text" required name="data_admissao" class="data form-control @error('data_admissao') is-invalid @enderror" value="{{ old('data_admissao') }}">
                        </div>
                        <div class="form-group col-5">
                            <label for="cargo_id">Cargo *</label>
                            <select required name="cargo_id" class="form-control @error('cargo_id') is-invalid @enderror">
                                @foreach ($cargos as $cargo)
                                <option value="{{ $cargo->id }}">{{ $cargo->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div id="div-aposentado" class="form-row">
                        <div class="form-group col-2">
                            <label for="paridade">Paridade</label>
                            <select id="select-paridade" name="paridade" class="form-control @error('paridade') is-invalid @enderror">
                                <option value="" {{  old('paridade') === '' ? 'selected' : '' }}></option>
                                <option value="1" {{ old('paridade') === '1' ? 'selected' : '' }}>Com</option>
                                <option value="0" {{ old('paridade') === '0' ? 'selected' : '' }}>Sem</option>
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="proventos">Proventos</label>
                            <select name="proventos" class="form-control @error('proventos') is-invalid @enderror">
                                <option value=""></option>
                                @foreach ($proventos as $provento)
                                <option value="{{ $provento->getIndex() }}" @if (old('proventos')==$provento->getIndex()) selected @endif>{{ $provento->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="tipo_aposentadoria">Tipo</label>
                            <select name="tipo_aposentadoria" class="form-control @error('tipo') is-invalid @enderror">
                                <option value=""></option>
                                @foreach ($tiposAposentadoria as $tipo)
                                <option value="{{ $tipo->getIndex() }}" @if (old('tipo_aposentadoria')==$tipo->getIndex()) selected @endif>{{ $tipo->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="data_aposentadoria">Data aposentadoria</label>
                            <input type="text" name="data_aposentadoria" class="data form-control @error('data_aposentadoria') is-invalid @enderror" value="{{ old('data_aposentadoria') }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="portaria_aposentadoria">Portaria</label>
                            <input type="text" name="portaria_aposentadoria" class="form-control @error('portaria_aposentadoria') is-invalid @enderror" maxlength="20" value="{{ old('portaria_aposentadoria') }}">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="readaptado">É readaptado *</label>
                            <select required id="select-readaptado" name="readaptado" class="form-control @error('readaptado') is-invalid @enderror">
                                <option value="0" {{ ! old('readaptado') ? 'selected' : '' }}>NÃO</option>
                                <option value="1" {{   old('readaptado') ? 'selected' : '' }}>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-3" id="div-cargo-readaptado">
                            <label for="cargoreadaptado_id">Cargo readaptado *</label>
                            <select id="select-cargo-readaptado" name="cargoreadaptado_id" class="form-control @error('cargoreadaptado_id') is-invalid @enderror">
                                <option value=""></option>

                                @foreach ($cargos as $cargo)
                                <option value="{{ $cargo->id }}">{{ $cargo->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2">
                            <label for="nivel_salarial_id">Nivel Salarial</label>
                            <select name="nivel_salarial_id" class="form-control @error('nivel_salarial_id') is-invalid @enderror">
                                <option value="">&nbsp;</option>
                                @foreach ($niveisSalariais as $nivelSalarial)
                                <option value="{{ $nivelSalarial->id }}" @if (old('nivel_salarial_id')==$nivelSalarial->id) selected @endif>{{ $nivelSalarial->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-2" id="div-data-desligamento">
                            <label for="data_desligamento">Data de desligamento</label>
                            <input type="text" name="data_desligamento" id="text-data-desligamento" class="data form-control @error('data_desligamento') is-invalid @enderror" value="{{ old('data_desligamento') }}">
                        </div>
                        <div class="form-group col-6">
                            <label for="unidadeorganizacional_id">Unidade Organizacional *</label>
                            <select required name="unidadeorganizacional_id" id="select-unidade-organizacional" class="form-control @error('unidadeorganizacional_id') is-invalid @enderror">
                                @foreach ($unidades as $unidade)
                                <option value="{{ $unidade->id }}" @if (old('unidadeorganizacional_id')==$unidade->id) selected @endif data-secretaria="{{ optional($unidade->secretaria())->sigla_nome }}">{{ $unidade->sigla_nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-5">
                            <label for="secretaria">Secretaria</label>
                            <input readonly class="form-control-plaintext" value="{{ old('secretaria') }}" id="text-secretaria">
                        </div>
                        <div class="form-group col-5">
                            <label for="endereco-lotacao">Aonde você fica</label>
                            <input id="endereco-lotacao" readonly class="form-control-plaintext" value="{{ old('endereco_lotacao') }}" name="endereco_lotacao">
                        </div>
                        <div class="form-group col-2" id="div-outro-endereco">
                            <label class="d-block">&nbsp;</label>
                            <button type="button" id="btn-escolher-endereco-lotacao" class="btn btn-outline-primary">Escolher outro</button>
                        </div>
                        <div class="form-group col-2" id="div-mesmo-endereco-unidade">
                            <label class="d-block">&nbsp;</label>
                            <button type="button" id="btn-mesmo-endereco-unidade" class="btn btn-outline-primary">Usar endereço</button>
                        </div>

                        @include('components.endereco', ['obrigatorio' => false])
                    </div>

                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
