@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/servidores/index.js') }}"></script>
@endpush

@push('css')
<link href="{{ asset('css/admin/servidores.css') }}" rel="stylesheet" type="text/css">
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Servidores</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Servidores
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts

                <div class="form-row">
                    <div class="col-2">
                        @button([
                        'route' => 'admin.servidores.create',
                        'icon' => 'plus',
                        'label' => 'Incluir',
                        'class' => 'btn-primary'
                        ])
                        @endbutton
                    </div>
                    <select name="situacao" form="filtro" class="form-control col" id="select-situacao">
                        @foreach ($situacoesServidores as $situacao)
                        <option value="{{ $situacao->getIndex() }}" {{ $situacaoSelecionada->isEqual($situacao) ? 'selected' : '' }}>{{ $situacao->getValue() }}</option>
                        @endforeach
                    </select>
                    <select name="filtro" form="filtro" class="form-control col" id="select-filtro">
                        @foreach ($filtrosServidores as $filtro)
                        <option value="{{ $filtro->getIndex() }}" {{ $filtroSelecionado->isEqual($filtro) ? 'selected' : '' }}>{{ $filtro->getValue() }}</option>
                        @endforeach
                    </select>
                    <div class="input-group col-4">
                        <input type="text" form="filtro" autocomplete="off" value="{{ $busca ?? '' }}" name="busca" class="form-control busca @error('busca') is-invalid @enderror">
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-outline-secondary" form="filtro" title="Buscar"><i data-feather="search"></i></button>
                            <a href="{{ route('admin.servidores.index') }}" class="btn btn-outline-secondary" title="Limpar"><i data-feather="x"></i></a>
                        </div>
                    </div>
                    <div class="form-check mt-2">
                        <input class="form-check-input" type="checkbox" form="filtro" name="excluidos" {{ $excluidos ?? false ? 'checked' : '' }}>
                        <label class="form-check-label" for="excluidos">
                            Excluídos
                        </label>
                    </div>
                </div>

                <form id="filtro">
                </form>

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Registro</th>
                            <th>CPF</th>
                            <th>Status</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($servidores as $servidor)
                        @php
                        if ($situacaoSelecionada->isTodos()) {
                        if ($servidor->desfiliadoTemporariamente()) {
                        $classe = 'desfiliado-temporariamente';
                        } elseif ($servidor->desfiliadoDefinitivamente()) {
                        $classe = 'desfiliado-definitivamente';
                        } else {
                        $classe = '';
                        }

                        $registro = $servidor->registros->first();
                        }
                        @endphp
                        <tr class="{{ $servidor->trashed() ? 'table-danger' : '' }} {{ $classe ?? '' }}">
                            <td>{{ $servidor->nome }}</td>
                            <td>{{ optional($registro)->numero }}</td>
                            <td>{{ $servidor->cpf }}</td>
                            <td>{{ $servidor->situacao() }}</td>
                            <td>
                                @button([
                                'route' => 'admin.servidores.edit',
                                'routeParams' => ['servidor' => $servidor],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-servidor',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.servidores.destroy',
                                'routeParams' => ['servidor' => $servidor],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $servidores->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-servidor" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-servidor">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o servidor?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
