@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/telefones.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Falecimento</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Falecimento de servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.servidores.atualiza-falecimento', ['servidor' => $servidor]) }}" method="post">
                    @csrf

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-2">
                            <label for="data_falecimento">Data do falecimento</label>
                            <input type="text" autofocus name="data_falecimento" data-mask="00/00/0000" class="form-control @error('data_falecimento') is-invalid @enderror" value="{{ old('data_falecimento', optional($servidor->data_falecimento)->format('d/m/Y')) }}">
                        </div>
                        <div class="form-group col-10">
                            <label for="nome_herdeiro">Nome herdeiro</label>
                            <input type="text" name="nome_herdeiro" maxlength="150" class="form-control @error('nome_herdeiro') is-invalid @enderror" value="{{ old('nome_herdeiro', optional($servidor->herdeiro)->nome) }}">
                        </div>

                        @include('components.endereco', ['endereco' => $endereco ?? null, 'obrigatorio' => false])

                        <div class="div-telefones form-row col-12">
                            @include('components.telefone', ['name' => 'telefone[0]', 'tipoTelefone' => 'celular', 'obrigatorio' => false,
                            'valor' => old('telefone.0.numero', optional($telefoneCelular)->valor), 'observacoes' => old('telefone.0.observacoes', optional($telefoneCelular)->observacoes),
                            ])
                            @include('components.telefone', ['name' => 'telefone[1]', 'valor' => old('telefone.1.numero', optional($telefoneFixo)->valor),
                            'observacoes' => old('telefone.1.observacoes', optional($telefoneFixo)->observacoes)])
                        </div>

                        <div class="form-group col-12">
                            <label for="observacao_falecimento">Observações falecimento</label>
                            <textarea name="observacao_falecimento" maxlength="255" class="form-control @error('observacao_falecimento') is-invalid @enderror">{{ old('observacao_falecimento') ?? $servidor->observacao_falecimento }}</textarea>
                        </div>
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Atualizar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
