@extends('layouts.admin')

@push('css')
<link href="{{ asset('css/admin/servidores-create-edit.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/servidores/edit.js') }}"></script>
<script src="{{ asset('js/admin/telefones.js') }}"></script>
<script src="{{ asset('js/admin/emails.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidores</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ $servidor->nome }}</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.servidores.update', ['servidor' => $servidor]) }}" method="post">
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <input type="hidden" id="hidden-sucesso-inclusao" value="{{ session('sucessoInclusao') }}">
                    <input type="hidden" id="hidden-sucesso-filiacao" value="{{ session('sucessoFiliacao') }}">
                    <input type="hidden" id="hidden-rota-voltar" value="{{ session('rotaVoltar') }}">
                    <input type="hidden" id="hidden-e-associado" value="{{ $servidorEAssociado }}">
                    <input type="hidden" id="hidden-termos-assinar" value="{{ session('termos-assinar') }}">

                    <div class="form-row">
                        <div class="col-9">
                            <div class="form-row">
                                <div class="form-group col-3">
                                    <label for="situacao">Situação</label>
                                    <input type="text" name="situacao" readonly class="form-control-plaintext" value="{{ $servidor->situacao() }}">
                                </div>
                                @if ($servidorEAssociado || $servidorDesfiliadoTemporariamente)
                                <div class="form-group col-2">
                                    <label for="matricula">Matrícula</label>
                                    <input type="text" name="matricula" readonly class="form-control-plaintext" value="{{ $matricula->id }}">
                                </div>
                                <div class="form-group col-2">
                                    <label for="data_filiacao">Data filiação</label>
                                    <input type="text" name="data_filiacao" readonly class="form-control-plaintext" value="{{ $matricula->data_filiacao->format('d/m/Y') }}">
                                </div>
                                @elseif ($servidorDesfiliadoDefinitivamente)
                                <div class="form-group col-4">
                                    <label for="motivo_desfiliacao">Motivo desfiliação</label>
                                    <input type="text" name="motivo_desfiliacao" readonly class="form-control-plaintext" value="{{ $matricula->motivo_desligamento }}">
                                </div>
                                @if ($matricula->motivo_desligamento->isFalecido())
                                <div class="form-group col-3">
                                    <label for="data_falecimento_readonly">Data falecimento</label>
                                    <input type="text" name="data_falecimento_readonly" readonly class="form-control-plaintext" value="{{ optional($servidor->data_falecimento)->format('d/m/Y') }}">
                                </div>
                                @elseif ($matricula->motivo_desligamento->isAny($motivosExoneracao))
                                <div class="form-group col-3">
                                    <label for="data_publicacao_portaria">Data pub. portaria</label>
                                    </label>
                                    <input type="text" name="data_publicacao_portaria" readonly class="form-control-plaintext" value="{{ optional($matricula->data_publicacao_portaria)->format('d/m/Y') }}">
                                </div>

                                @endif

                                @endif
                            </div>
                            <div class="form-row">
                                <div class="form-group col-6">
                                    <label for="nome">Nome *</label>
                                    <input type="text" autofocus name="nome" maxlength="150" class="form-control @error('nome') is-invalid @enderror" value="{{ old('nome') ?? $servidor->nome }}">
                                </div>
                                <div class="form-group col-6">
                                    <label for="nome_social">Nome social</label>
                                    <input type="text" name="nome_social" maxlength="150" class="form-control @error('nome_social') is-invalid @enderror" value="{{ old('nome_social') ?? $servidor->nome_social }}">
                                </div>
                                <div class="form-group col-4">
                                    <label for="cpf">CPF *</label>
                                    <input type="text" name="cpf" required maxlength="14" class="cpf form-control @error('cpf') is-invalid @enderror" value="{{ old('cpf') ?? $servidor->cpf }}">
                                </div>
                                <div class="form-group col-4">
                                    <label for="rg">RG</label>
                                    <input type="text" name="rg" maxlength="15" class="form-control @error('rg') is-invalid @enderror" value="{{ old('rg') ?? $servidor->rg }}">
                                </div>
                                <div class="form-group col-4">
                                    <label for="estado_civil">Estado civil</label>
                                    <select name="estado_civil" class="form-control @error('estado_civil') is-invalid @enderror">
                                        <option value=""></option>
                                        @foreach ($estadosCivis as $estadoCivil)
                                        <option value="{{ $estadoCivil->getIndex() }}" {{ optional($servidor->estado_civil)->isEqual($estadoCivil) ? 'selected': '' }}>{{ $estadoCivil->getValue() }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-3">
                                    <label for="sexo">Sexo</label>
                                    <select name="sexo" class="form-control @error('sexo') is-invalid @enderror">
                                        <option value=""></option>
                                        @foreach ($sexos as $sexo)
                                        <option value="{{ $sexo->getIndex() }}" {{ optional($servidor->sexo)->isEqual($sexo) ? 'selected': '' }}>{{ $sexo->getValue() }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-3">
                                    <label for="data_nascimento">Data de nascimento</label>
                                    <input type="text" name="data_nascimento" class="data form-control @error('data_nascimento') is-invalid @enderror" value="{{ old('data_nascimento') ?? optional($servidor->data_nascimento)->format('d/m/Y') }}">
                                </div>
                                <div class="form-group col-4">
                                    <label for="naturalidade">Naturalidade</label>
                                    <input type="text" id="naturalidade" name="naturalidade" maxlength="150" class="form-control @error('naturalidade') is-invalid @enderror" value="{{ old('naturalidade') ?? $servidor->naturalidade }}">
                                </div>
                                <div class="form-group col-2">
                                    <label for="naturalidade_uf">Naturalidade/UF</label>
                                    <select name="naturalidade_uf" class="form-control @error('naturalidade_uf') is-invalid @enderror">
                                        <option value="" @if (old('naturalidade_uf', $servidor->naturalidade_uf) == null) selected @endif></option>
                                        @foreach ($estados as $estado)
                                        <option value="{{ $estado->ufe_sg }}" {{ old('naturalidade_uf', $servidor->naturalidade_uf) == $estado->ufe_sg ? 'selected' : '' }}>{{ $estado->ufe_sg }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-3" id="div-foto">
                            <img src='{{ $servidor->imagem ? asset("storage/servidores/$servidor->imagem") : "" }}' />
                            <input type="hidden" id="hidden-imagem-camera" name="imagem_camera">
                            <input type="hidden" id="hidden-remover-imagem" name="remover_imagem">
                            <div id="div-botoes-foto">
                                <button type="button" id="btn-abrir-captura-foto" class="btn btn-outline-primary btn-sm" alt="Obter foto pela webcam"><i data-feather="camera"></i></button>
                                <button type="button" id="btn-remover-foto" class="btn btn-outline-primary btn-sm" alt="Remover foto"><i data-feather="x"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-3">
                            <label for="nacionalidade">Nacionalidade</label>
                            <input type="text" name="nacionalidade" maxlength="150" class="form-control @error('nacionalidade') is-invalid @enderror" value="{{ old('nacionalidade') ?? $servidor->nacionalidade }}">
                        </div>
                        <div class="form-group col-2">
                            <label for="nao_perturbe">Não perturbar</label>
                            <select name="nao_perturbe" class="form-control @error('nao_perturbe') is-invalid @enderror">
                                <option value="0" @if (! old('nao_perturbe', $servidor->nao_perturbe)) selected @endif>NÃO</option>
                                <option value="1" @if ( old('nao_perturbe', $servidor->nao_perturbe)) selected @endif>SIM</option>
                            </select>
                        </div>
                        <div class="form-group col-3">
                            <label for="nivel_ensino">Nível de ensino</label>
                            <select name="nivel_ensino" class="form-control @error('nivel_ensino') is-invalid @enderror" value="{{ old('nivel_ensino') }}">
                                <option value=""></option>
                                @foreach ($niveisEnsino as $nivel)
                                <option value="{{ $nivel->getIndex() }}" @if (old('nivel_ensino', optional($servidor->nivel_ensino)->getIndex()) == $nivel->getIndex()) selected @endif>{{ $nivel->getValue() }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4">
                            <label for="nome_mae">Nome da mãe</label>
                            <input type="text" name="nome_mae" maxlength="150" class="form-control @error('nome_mae') is-invalid @enderror" value="{{ old('nome_mae') ?? $servidor->nome_mae }}">
                        </div>
                        <div class="form-group col-3">
                            <label for="nome_pai">Nome do pai</label>
                            <input type="text" name="nome_pai" maxlength="150" class="form-control @error('nome_pai') is-invalid @enderror" value="{{ old('nome_pai') ?? $servidor->nome_pai }}">
                        </div>
                        <div class="form-group col-12">
                            <label for="observacoes">Observações</label>
                            <textarea name="observacoes" class="form-control @error('observacoes') is-invalid @enderror">{{ old('observacoes') ?? $servidor->observacoes }}</textarea>
                        </div>
                    </div>

                    <h5 class="hk-pg-title">
                        Contatos
                    </h5>
                    <hr>
                    <div class="my-10">
                        <button id="btn-incluir-fixo" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone fixo</button>
                        <button id="btn-incluir-celular" type="button" class="btn btn-primary"><i data-feather="plus"></i> Telefone celular</button>
                        <button id="btn-incluir-email" type="button" class="btn btn-primary"><i data-feather="plus"></i> E-mail</button>
                    </div>
                    @include('components.telefones', ['telefones' => $servidor->contatos()->telefones()->get(), 'malaDireta' => true])
                    @include('components.emails', ['emails' => $servidor->contatos()->emails()->get(), 'malaDireta' => true])

                    <h5 class="hk-pg-title">
                        Endereços
                    </h5>
                    <hr>
                    @button([
                    'route' => 'admin.servidores.enderecos.create',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'plus',
                    'label' => 'Incluir',
                    'class' => 'btn-primary'
                    ])
                    @endbutton

                    <div class="form-row">
                        @include('components.listagem-endereco', ['enderecos' => $servidor->enderecos])
                    </div>

                    <h5 class="hk-pg-title">
                        Dados Funcionais
                    </h5>
                    <hr>
                    @button([
                    'route' => 'admin.servidores.registros.create',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'plus',
                    'label' => 'Incluir',
                    'class' => 'btn-primary'
                    ])
                    @endbutton

                    <div class="form-row">
                        @include('components.listagem-registros', ['registros' => $servidor->registros])
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton

                    @if ($servidor->trashed())
                    @button([
                    'icon' => 'refresh-ccw',
                    'label' => 'Restaurar',
                    'class' => 'btn-primary btn-restaurar-servidor'
                    ])
                    @endbutton
                    @endif

                    @if ($servidorEAssociado)
                    @button([
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.desfilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Desfiliar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @elseif ($servidorDesfiliadoTemporariamente)
                    @button([
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.afilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Reafiliar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton

                    @button([
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.desfilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Desfiliar definit.',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @elseif ($servidorDesfiliadoDefinitivamente)
                    @button([
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.religamento-extraordinario-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Relig. extraordinário',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.afilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Afiliar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @else
                    @button([
                    'icon' => 'credit-card',
                    'route' => 'admin.servidores.afilia-form',
                    'routeParams' => ['servidor' => $servidor],
                    'label' => 'Afiliar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton

                    @endif

                    @button([
                    'route' => 'admin.servidores.dependentes.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'users',
                    'label' => 'Dependentes',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.servidores.convenios.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'list',
                    'label' => 'Convênios',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.servidores.documentos.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'file',
                    'label' => 'Documentos',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton

                    @button([
                    'icon' => 'file-text',
                    'label' => 'Processos',
                    'class' => 'btn-secondary',
                    'route' => 'admin.processos-juridicos.index',
                    'routeParams' => ['pessoa' => $servidor->id, 'tipo' => 'associado']
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.guia-atendimento.create',
                    'routeParams' => ['servidor' => $servidor],
                    'class' => 'btn-secondary',
                    'label' => 'Atender',
                    'icon' => 'clipboard'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.anamnese-atendimento.create-edit',
                    'routeParams' => ['pessoa' => $servidor, 'tipo' => 'associado'],
                    'class' => 'btn-secondary',
                    'label' => 'Anamnese',
                    'icon' => 'clipboard'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.servidores.movimentacoes.index',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'list',
                    'label' => 'Movimentações',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.servidores.falecimento-form',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'x',
                    'label' => 'Falecimento',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton

                    @if (count($todosDocumentosImprimir) > 0)
                    @button([
                    'icon' => 'printer',
                    'label' => 'Imprimir documentos',
                    'class' => 'btn-secondary',
                    'id' => 'btn-imprimir-documentos',
                    ])
                    @endbutton
                    @endif

                    @button([
                    'route' => 'admin.servidores.index',
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
<div class="modal" id="modal-pergunta" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5>{{ session('status') }}</h5>
            </div>
            <div class="modal-body">
                <p>Servidor deseja se afiliar ao sindicato?</p>
            </div>
            <div class="modal-footer">
                <a href="{{ route('admin.servidores.afilia-form', ['servidor' => $servidor]) }}" class="btn btn-primary" id="btn-afilia">Sim</a>
                <button type="button" class="btn btn-secondary" id="btn-nao-afiliar">Não</button>
                <button type="button" class="btn btn-secondary" id="btn-voltar">Voltar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="modal-sucesso-filiacao" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <p>{{ session('status') }}</p>
            </div>
            <div class="modal-body">
                <p>Atenção: Não se esqueça de imprimir o documento abaixo para assinatura do novo associado</p>

                <ul class="mt-3">
                    @foreach ($documentosImprimirFiliacao as $documento)
                    <li><a target="new" href="{{ $documento->url }}">{{ $documento->texto }}</a></li>
                    @endforeach
                    <li><a target="new" href="{{ route('admin.formularios.servidores.ficha-inscricao', ['servidor' => $servidor]) }}">Ficha de Inscrição / Autorização para Descontos</a></li>
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-endereco" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-endereco">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o endereço?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-excluir-registro" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-registro">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o registro?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-restaurar-servidor" tabindex="-1" role="dialog">
    <form method="POST" id="form-restaurar-servidor" action="{{ route('admin.servidores.restore', ['servidor' => $servidor])  }}">
        @csrf
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente restaurar o servidor?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="modal-impressao-documentos" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <p>Imprimir documentos do servidor</p>
            </div>
            <div class="modal-body">
                <ul>
                    @foreach ($todosDocumentosImprimir as $documento)
                    <li><a target="new" href="{{ $documento->url }}">{{ $documento->texto }}</a></li>
                    @endforeach
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-termos-assinar" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <p>{{ session('status') }}</p>
            </div>
            <div class="modal-body">
                <p>Atenção: Imprima os documentos de desligamento do associado e os termos de desligamento dos convênios abaixo:</p>

                <ul class="mt-3">
                    @foreach ($documentosImprimirDesligamento as $documento)
                    <li><a target="new" href="{{ $documento->url }}">{{ $documento->texto }}</a></li>
                    @endforeach
                </ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-captura-foto" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Capturar foto</h3>
            </div>
            <div class="modal-body">
                <video autoplay></video>
            </div>
            <div class="modal-footer">
                <button id="btn-captura-foto" type="button" class="btn btn-primary">Capturar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
@endsection
