@extends('layouts.admin')

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidor</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Incluir documento</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar documento
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.servidores.documentos.update', ['servidor' => $servidor, 'documento' => $documento]) }}" method="post" enctype='multipart/form-data'>
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-3">
                            <label for="tipo">Tipo *</label>
                            <select required name="tipo" class="form-control @error('tipo') is-invalid @enderror">
                                @foreach ($tipos as $tipo)
                                <option value="{{ $tipo->id }}" {{ $documento->tipo->id == $tipo->id ? 'selected' : '' }}>{{ $tipo->nome }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-5">
                            <label for="arquivo" class="d-block">Arquivo</label>
                            <input type="file" name="arquivo" class="documento @error('arquivo') is-invalid @enderror" value="{{ old('arquivo') }}">
                        </div>
                        <div class="form-group col-4">
                            <label for="observacoes">Observações</label>
                            <input type="text" name="observacoes" class="form-control @error('observacoes') is-invalid @enderror" value="{{ old('observacoes') ?? $documento->observacoes }}">
                        </div>
                        @if ($documento->eImagem())
                            <img class="col-4" src=" {{ asset('storage/' . $documento->caminho) }}">
                        @endif
                    </div>

                    <hr>
                    @button([
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.servidores.documentos.download',
                    'routeParams' => ['documento' => $documento, 'servidor' => $servidor],
                    'class' => 'btn-primary',
                    'label' => 'Baixar',
                    'icon' => 'download'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection