@extends('layouts.admin')

@push('css')
<link href="{{ asset('css/admin/servidores-create-edit.css') }}" rel="stylesheet" type="text/css">
@endpush

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
<script src="{{ asset('js/admin/afilia.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.index') }}">Servidores</a></li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.servidores.edit', ['servidor' => $servidor]) }}">{{ $servidor->nome }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Afiliar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Afiliar servidor
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.servidores.afilia', ['servidor' => $servidor]) }}" method="post">
                    @csrf

                    @alerts
                    @endalerts

                    <div class="form-row">
                        @if ($matriculaDesligadaTemporariamente)
                        <div class="form-group col-2">
                            <label for="matricula">Matrícula</label>
                            <input type="text" name="matricula" maxlength="100" readonly class="form-control-plaintext" value="{{ $matriculaDesligadaTemporariamente->id }}">
                        </div>
                        @endif
                        @if (!$matriculaDesligadaTemporariamente)
                        <div class="form-group col-4">
                            <label for="motivo_filiacao">Motivo *</label>
                            <select autofocus required class="form-control" name="motivo_filiacao" id="motivo_filiacao">
                                @foreach ($motivos as $motivo)
                                <option value="{{ $motivo->id }}" @if(old('motivo_filiacao')==$motivo->id) selected @endif>{{ $motivo->descricao }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-4" id="div-motivo-outros">
                            <label for="motivo_filiacao_outros">Detalhe do motivo *</label>
                            <input type="text" maxlength="100" name="motivo_filiacao_outros" class="form-control @error('motivo_filiacao_outros') is-invalid @enderror" value="{{ old('motivo_filiacao_outros') }}">
                        </div>
                        <div class="form-group col-2" id="div-data-filiacao">
                            <label for="data_filiacao">Data de admissão *</label>
                            <input type="text" required name="data_filiacao" data-mask="00/00/0000" data-mask-clearifnotmatch="true" class="form-control @error('data_filiacao') is-invalid @enderror" value="{{ old('data_filiacao', today()->format('d/m/Y')) }}">
                        </div>
                        @endif
                    </div>

                    <div class="clearfix"></div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Afiliar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton

                    @button([
                    'route' => 'admin.servidores.edit',
                    'routeParams' => ['servidor' => $servidor],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection
