@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item" aria-current="page">Atendimento Jurídico</li>
        <li class="breadcrumb-item" aria-current="page">Processos</li>
        <li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.processos-juridicos.edit', ['id' => $processo->id, 'pessoa' => request()->pessoa, 'tipo' => request()->tipo]) }}">Processo {{ $processo->numeroCompleto() }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">Editar</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Editar anexo
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                <form action="{{ route('admin.anexos-processos-juridicos.update', ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'idProcesso' => $processo->id, 'id' => $anexo->id]) }}" method="post" enctype='multipart/form-data'>
                    @csrf
                    @method('PUT')

                    @alerts
                    @endalerts

                    <div class="form-row">
                        <div class="form-group col-6">
                            <label class="d-block" for="arquivo">Arquivo</label>
                            <input type="file" name="arquivo" class="@error('arquivo') is-invalid @enderror">
                        </div>
                        <div class="form-group col-6">
                            <label for="descricao">Descrição *</label>
                            <input type="text" required autofocus name="descricao" maxlength="50" class="form-control @error('descricao') is-invalid @enderror" value="{{ old('descricao', $anexo->descricao) }}">
                        </div>
                    </div>
                    <hr>
                    @button([
                    'icon' => 'save',
                    'label' => 'Salvar',
                    'class' => 'btn-primary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.anexos-processos-juridicos.download',
                    'routeParams' => ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'idProcesso' => $processo->id, 'id' => $anexo->id],
                    'icon' => 'download',
                    'label' => 'Download',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                    @button([
                    'route' => 'admin.processos-juridicos.edit',
                    'routeParams' => ['tipo' => request()->tipo, 'pessoa' => request()->pessoa, 'id' => $processo->id],
                    'icon' => 'arrow-left',
                    'label' => 'Voltar',
                    'class' => 'btn-secondary'
                    ])
                    @endbutton
                </form>
            </section>
        </div>
    </div>
</div>
@endsection