@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/prestadores-servicos/index.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Prestadores de serviços</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Prestadores de serviços
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts
                
                @button([
                'route' => 'admin.prestadores-servicos.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                @busca([
                'route' => 'admin.prestadores-servicos.index',
                'busca' => $termo ?? null
                ])
                @endbusca

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Função</th>
                            <th>Telefone(s)</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($prestadores as $prestador)
                        <tr>
                            <td>{{ $prestador->nome }}</td>
                            <td>{{ $prestador->funcao }}</td>
                            <td>{{ implode(' ', $prestador->contatos()->telefones()->take(2)->get()->pluck('valor')->toArray()) }}</td>
                            <td>
                                @button([
                                'route' => 'admin.prestadores-servicos.edit',
                                'routeParams' => ['prestador' => $prestador],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-prestador',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.prestadores-servicos.destroy',
                                'routeParams' => ['prestador' => $prestador],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $prestadores->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-prestador" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-prestador">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o prestador?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection