@extends('layouts.admin')

@push('js')
<script src="{{ asset('js/admin/planos-contas.js') }}"></script>
@endpush

@section('content')
<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item active" aria-current="page">Planos de contas</li>
    </ol>
</nav>
<!-- /Breadcrumb -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="align-left"></i></span></span>
            Planos de conta
        </h4>
    </div>
    <!-- /Title -->
    <div class="row">
        <div class="col-xl-12">
            <section class="hk-sec-wrapper">
                @alerts
                @endalerts
                
                @button([
                'route' => 'admin.planos-contas.create',
                'icon' => 'plus',
                'label' => 'Incluir',
                'class' => 'btn-primary'
                ])
                @endbutton

                @busca([
                'route' => 'admin.planos-contas.index',
                'busca' => $busca
                ])
                @endbusca

                <table class="table mt-3">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th class="w-25">Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($planos as $plano)
                        <tr>
                            <td>{{ $plano->nome }}</td>
                            <td>
                                @button([
                                'route' => 'admin.planos-contas.edit',
                                'routeParams' => ['plano' => $plano],
                                'class' => 'btn-primary',
                                'label' => 'Visualizar/Editar',
                                'icon' => 'edit'
                                ])
                                @endbutton
                                @button([
                                'class' => 'btn-danger btn-excluir-plano',
                                'icon' => 'x',
                                'label' => 'Excluir',
                                'route' => 'admin.planos-contas.destroy',
                                'routeParams' => ['plano' => $plano],
                                ])
                                @endbutton
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $planos->links() }}
            </section>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-excluir-plano" tabindex="-1" role="dialog">
    <form method="POST" id="form-excluir-plano">
        @csrf
        @method('DELETE')
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <p>Deseja realmente excluir o plano e todas as classificações relacionadas a ele?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Sim</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection